/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayTimeLat;
import gov.nasa.giss.panoply.data.PanDataTimeY;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataTimeLat
extends PanDataTimeY {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanDataTimeLat(PanPlotMeta pmeta, NcArray nca, Dimension size) {
        this(pmeta, nca, size.width, size.height);
    }

    public PanDataTimeLat(PanPlotMeta pmeta, NcArray nca, int gridWidth, int gridHeight) {
        super(pmeta, nca, gridWidth, gridHeight);
        this.setGridBottomAndTop(-90.0, 90.0);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayTimeLat)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayTimeLat.");
        }
        return true;
    }

    @Override
    protected void prepareYAxisUnits() {
    }

    @Override
    public String getYAxisName() {
        return "Latitude";
    }

    @Override
    public String getDataYAxisUnits() {
        return "degree_north";
    }

    @Override
    public String getYAxisUnits() {
        return "degree_north";
    }

    @Override
    public void setYAxisUnits(String unitsStr) {
        LOGGER.trace("Cannot set Y-axis units for time-lat data grid.");
    }

    @Override
    public PanAxisMethod getYAxisMethod() {
        return PanAxisMethod.SCALAR;
    }

    @Override
    public void setYAxisMethod(PanAxisMethod method) {
        LOGGER.trace("Cannot set Y-axis method for lat-time data grid. Using SCALAR.");
    }
}

