/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanToggleControlsWindoidAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final PanPlotFrame pframe_;
    final PanPlotControlsID cid_;
    private double last_;

    public PanToggleControlsWindoidAction(PanPlotFrame pframe, PanPlotControlsID cid) {
        this.pframe_ = pframe;
        this.cid_ = cid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanPlotWindoid windoid;
        long now = System.currentTimeMillis();
        if (!((double)now - this.last_ < 200.0) && (windoid = this.pframe_.getControlsWindoid(this.cid_)) instanceof PanPlotWindoid) {
            boolean oldState = this.pframe_.areControlsVisible(this.cid_);
            this.pframe_.setControlsVisible(this.cid_, !oldState);
            if (!oldState) {
                windoid.requestFocus();
            }
        }
        this.last_ = now;
        this.pframe_.getPanMenuBar().refresh();
    }
}

