/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.symbol;

import gov.nasa.giss.util.DescribedItem;

public enum SymbolID implements DescribedItem
{
    NONE("None", false),
    DOT("Dot", true),
    CROSS("Cross", false),
    SALTIRE("Saltire", false),
    ASTERISK("Asterisk", false),
    ASTERISK8("Asterisk of 8", false),
    CIRCLE("Circle", true),
    TRIANGLE("Triangle", true),
    INV_TRIANGLE("Inverted Triangle", true),
    SQUARE("Square", true),
    DIAMOND("Diamond", true),
    PENTAGON("Pentagon", true),
    HEXAGON("Hexagon", true),
    HEPTAGON("Heptagon", true),
    OCTAGON("Octagon", true),
    STAR("Star", true),
    INV_STAR("Inverted Star", true),
    STAR6("Star of 6", true),
    STAR7("Star of 7", true),
    STAR8("Star of 8", true);

    private final String description_;
    private final boolean closed_;

    private SymbolID(String description, boolean closed) {
        this.description_ = description;
        this.closed_ = closed;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    public static SymbolID matching(String str) {
        for (SymbolID item : SymbolID.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }
}

