/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjDoubleComponent
extends ProjParamComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 181L;
    private static final PrintfFormat NFORMAT = new PrintfFormat("%.5g");
    private final ProjDoubleParameter parameter_;
    private JTextField tf_;
    private JLabel unitsLabel_;

    public ProjDoubleComponent(ProjDoubleParameter xparam) {
        this(xparam, xparam.getDefault());
    }

    public ProjDoubleComponent(ProjDoubleParameter xparam, double value) {
        super(xparam);
        this.parameter_ = xparam;
        this.createLayout(value);
        this.attachListeners();
    }

    @Override
    public JComponent getComponent() {
        return this.tf_;
    }

    private void createLayout(double value) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ":\u2009");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.tf_ = new JTextField(5);
        this.tf_.setHorizontalAlignment(4);
        this.setValue(value);
        this.add(this.tf_);
        String punits = this.parameter_.getUnits();
        String unitsStr = punits == null ? "" : punits;
        this.unitsLabel_ = new JLabel(unitsStr);
        this.unitsLabel_.setOpaque(false);
        this.add(this.unitsLabel_);
    }

    public void setUnitsStr(String newStr) {
        this.unitsLabel_.setText(newStr);
        this.unitsLabel_.repaint();
    }

    private void attachListeners() {
        this.tf_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ProjDoubleComponent.this.handleChange();
            }
        });
        this.tf_.addActionListener(e -> this.handleChange());
    }

    @Override
    public void reset() {
        this.tf_.setText(NFORMAT.sprintfx(this.parameter_.getDefault()));
        this.handleChange();
    }

    @Override
    public String getStringValue() {
        return NFORMAT.sprintfx(this.getValue());
    }

    public double getDoubleValue() {
        try {
            return StringUtils.parseDouble(this.tf_.getText());
        }
        catch (Exception exc) {
            return Double.NaN;
        }
    }

    @Override
    public Object getValue() {
        try {
            return StringUtils.parseDouble(this.tf_.getText());
        }
        catch (Exception exc) {
            return this.parameter_.getValue();
        }
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        LOGGER.trace("sval {}", (Object)sval);
        try {
            this.setValue(StringUtils.parseDouble(sval));
        }
        catch (Exception exc) {
            LOGGER.warn("Could not create double sval {}", (Object)sval);
            throw new IllegalArgumentException("Value is not a Double: " + sval);
        }
    }

    public void setValue(double dval) {
        LOGGER.trace("dval {}", (Object)dval);
        String oldText = this.tf_.getText();
        try {
            this.tf_.setText(NFORMAT.sprintfx(dval));
            if (dval == this.parameter_.getValue()) {
                return;
            }
            this.parameter_.setValue(dval);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not apply dval {}, reverting", (Object)dval);
            this.tf_.setText(oldText);
        }
        this.tf_.repaint();
        this.fireValueChanged();
    }

    @Override
    protected void handleChange() {
        try {
            double dval = StringUtils.parseDouble(this.tf_.getText());
            this.parameter_.setValue(dval);
        }
        catch (Exception exc) {
            LOGGER.warn(exc.getMessage());
            this.tf_.setText(NFORMAT.sprintfx(this.parameter_.getValue()));
            this.tf_.repaint();
        }
        this.fireValueChanged();
    }
}

