/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Winkel1
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Winkel I";
    private static final double DEFAULT_COS_PHI1 = 0.6366197723675814;
    private static final double DEFAULT_PHI1 = Math.toDegrees(Math.acos(0.6366197723675814));
    private static final double MAX_X_OVER_RS = 2.5707963267948966;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private double cosPhi1_ = 0.6366197723675814;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", DEFAULT_PHI1, -90.0, 90.0, true, true);

    public Winkel1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Winkel1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.5707963267948966, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.phi1Param_)) {
            this.setStandardParallel(this.phi1Param_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90,90].");
        }
        this.cosPhi1_ = Math.cos(Math.toRadians(lat));
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(1.5707963267948966 * (this.cosPhi1_ + 1.0), 1.5707963267948966);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double x = 0.5 * this.lonToLambdaRad(lon) * (this.cosPhi1_ + Math.cos(phiRad));
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * 2.0 * this.invRS_ / (this.cosPhi1_ + Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Winkel1 winkel1 = this;
        synchronized (winkel1) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = 2.0 * this.invRS_ / (this.cosPhi1_ + Math.cos(phiRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

