/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wiechel
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wiechel";
    public static final int PROPERTIES = 0x200080;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 180.0;
    private static final double MIN_RADIUS = 0.002;
    private double cosPhiC_;
    private double sinPhiC_;
    private double edgeAngle_ = 90.0;
    private double edgeAngleRad_;
    private double rhoBorder_;
    private double rhoBorder2_;
    private double extraRotRad_;
    private boolean fillCorners_;
    private final ProjDoubleParameter edgeParam_ = new ProjDoubleParameter("Angular distance between center and nearest edge of map", "Edge Angle", "\u00b0 (\u2264180.0\u00b0)", 90.0, 0.002, 180.0, true, true);
    private final ProjDoubleParameter rotateParam_ = new ProjDoubleParameter("Azimuth (clockwise)", "Azimuth", "\u00b0", 0.0, -180.0, 180.0, true, true);
    private final ProjBooleanParameter fillParam_ = new ProjBooleanParameter("Map is not limited to purely circular area", "Fill corners", true);

    public Wiechel(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wiechel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200080, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.edgeParam_);
        this.addParameter(this.rotateParam_);
        this.addParameter(this.fillParam_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setEdgeAngle(this.edgeParam_.getValue());
            this.setAzimuthalFill(this.fillParam_.isSelected());
            this.setExtraRotation(this.rotateParam_.getValue());
        } else if (p.equals(this.edgeParam_)) {
            this.setEdgeAngle(this.edgeParam_.getValue());
        } else if (p.equals(this.fillParam_)) {
            this.setAzimuthalFill(this.fillParam_.isSelected());
        } else if (p.equals(this.rotateParam_)) {
            this.setExtraRotation(this.rotateParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setEdgeAngle(double r) {
        this.edgeAngle_ = r;
        this.edgeAngleRad_ = Math.toRadians(this.edgeAngle_);
        this.autoscale();
    }

    private void setExtraRotation(double r) {
        this.extraRotRad_ = Math.toRadians(r);
        this.autoscale();
    }

    private final void setAzimuthalFill(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = 1.4142135623730951 * Math.sqrt(1.0 - Math.cos(this.edgeAngleRad_));
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.fillCorners_ ? 2.0 * this.rS_ : this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double rho2;
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        double z = Math.acos(cosZ);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(z) > 1.0E-5) {
            double k = Math.sqrt(2.0 / (1.0 + cosZ));
            double xP = k * cosPhi * Math.sin(lambdaRad);
            double yP = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
            double zz = 0.5 * z + this.extraRotRad_;
            double cosZZ = Math.cos(zz);
            double sinZZ = Math.sin(zz);
            x = xP * cosZZ + yP * sinZZ;
            y = -xP * sinZZ + yP * cosZZ;
        }
        if ((rho2 = x * x + y * y) * this.r2s2_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = 2.0 * Math.asin(rho * 0.5 * this.invRS_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double zz = 0.5 * z + this.extraRotRad_;
        double cosZZ = Math.cos(zz);
        double sinZZ = Math.sin(zz);
        double xP = x * cosZZ - y * sinZZ;
        double yP = x * sinZZ + y * cosZZ;
        double lambdaRad = Math.atan2(xP * sinZ, rho * this.cosPhiC_ * cosZ - yP * this.sinPhiC_ * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + yP * sinZ * this.cosPhiC_ / rho);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wiechel wiechel = this;
        synchronized (wiechel) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > this.rhoBorder2_) continue;
                    double rho = Math.sqrt(rho2);
                    double z = 2.0 * Math.asin(rho * 0.5 * this.invRS_);
                    double sinZ = Math.sin(z);
                    double cosZ = Math.cos(z);
                    double zz = 0.5 * z + this.extraRotRad_;
                    double cosZZ = Math.cos(zz);
                    double sinZZ = Math.sin(zz);
                    double xP = x * cosZZ - y * sinZZ;
                    double yP = x * sinZZ + y * cosZZ;
                    double lambdaRad = Math.atan2(xP * sinZ, rho * this.cosPhiC_ * cosZ - yP * this.sinPhiC_ * sinZ);
                    double phiRad = Math.asin(cosZ * this.sinPhiC_ + yP * sinZ * this.cosPhiC_ / rho);
                    this.setInvPoint(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private void setInvPoint(int ix, int iy, double dlambda, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        double lon = this.lambdaC_ + dlambda;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawCircle(g2d, this.rhoBorder_, true);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            if (Math.abs(this.phiC_ - lat) >= this.edgeAngle_ && !this.fillCorners_) {
                return;
            }
            double phiRad = Math.toRadians(lat);
            double sinPhi = Math.sin(phiRad);
            double rho = this.rS_ * Math.sqrt(2.0 * (1.0 - sinPhi));
            this.drawCircle(g2d, rho, false);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    private void drawCircle(Graphics2D g2d, double radius, boolean link) {
        double r2 = radius * radius;
        double w2 = this.dxMax_ * this.dxMax_;
        double h2 = this.dyMax_ * this.dyMax_;
        double rhoCorner = Math.sqrt(w2 + h2);
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.translate(this.outCenterX_, this.outCenterY_);
        Arc2D.Double arc = new Arc2D.Double();
        if (radius <= (double)this.dxMax_ && radius <= (double)this.dyMax_) {
            ProjGraphicUtils.drawEllipse(g2x, 0.0, 0.0, radius, radius);
        } else if (radius > rhoCorner) {
            if (link) {
                ProjGraphicUtils.drawRect(g2x, -this.dxMax_, -this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            }
        } else if (radius > (double)this.dxMax_ && radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(this.dxMax_, -dyy);
                path.lineTo(this.dxMax_, dyy);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                path.moveTo(-this.dxMax_, dyy);
                path.lineTo(-this.dxMax_, -dyy);
                g2x.draw(path);
            }
            double angle1 = -Math.toDegrees(Math.acos(dxx / radius));
            double angle2 = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double extent = Math.abs(angle1 + angle2);
            arc.setArcByCenter(0.0, 0.0, radius, angle1, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, -angle1, -extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle1, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 - angle1, -extent, 0);
            g2x.draw(arc);
        } else if (radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                g2x.draw(path);
            }
            double angle = -Math.toDegrees(Math.acos(dxx / radius));
            double extent = -2.0 * angle;
            arc.setArcByCenter(0.0, 0.0, radius, angle, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, extent, 0);
            g2x.draw(arc);
        } else if (radius > (double)this.dxMax_) {
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-this.dxMax_, -dyy);
                path.lineTo(-this.dxMax_, dyy);
                path.moveTo(this.dxMax_, dyy);
                path.lineTo(this.dxMax_, -dyy);
                g2x.draw(path);
            }
            double angle = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double extent = 180.0 - 2.0 * angle;
            arc.setArcByCenter(0.0, 0.0, radius, angle, extent, 0);
            g2x.draw(arc);
            arc.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, extent, 0);
            g2x.draw(arc);
        }
        g2x.dispose();
    }
}

