/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class QuadEllipseProjection
extends QuadSymmetricProjection {
    public QuadEllipseProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
            GraphicUtils.drawLine(g2d, this.outCenterX_, dotN.y, this.outCenterX_, dotS.y);
        } else {
            super.drawMeridian(g2d, lon, maxLat, label);
        }
    }
}

