/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.TwoHemisphereAzimuthalProjection;

public class Orthographic2H
extends TwoHemisphereAzimuthalProjection {
    public static final String PROJECTION_NAME = "Orthographic (Two-Hemisphere)";
    private static final double RADIUS_FACTOR = 1.0;

    public Orthographic2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public Orthographic2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 44040256, width, height, xmargin, ymargin, 1.0);
        this.finishConstruction();
    }

    @Override
    protected double getKForLambdaPPhiP(double lambdaPRad, double phiPRad) {
        return 1.0;
    }

    @Override
    protected double getZRadForRho(double rho) {
        return Math.asin(rho * this.invRS_);
    }
}

