/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ObliqueEllipseProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MollweideOblique
extends ObliqueEllipseProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Mollweide (Oblique)";
    public static final int PROPERTIES = 10493960;
    private static final double CSUBX = 0.9003163161571062;
    private static final double CSUBY = 1.4142135623730951;
    private static final double CSUBX_B = 1.0;
    private static final double CSUBY_B = 1.2732395447351628;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double cSubX_ = 0.9003163161571062;
    private double cSubY_ = 1.4142135623730951;
    private final ProjBooleanParameter bromleyParam_ = new ProjBooleanParameter("Apply Bromley's scaling", "Apply Bromley's scaling", false);

    public MollweideOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public MollweideOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 10493960, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        this.addParameter(this.bromleyParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setBromleyScaling(this.bromleyParam_.isSelected());
            super.parameterChanged(e);
        } else if (p.equals(this.bromleyParam_)) {
            this.setBromleyScaling(this.bromleyParam_.isSelected());
        } else {
            super.parameterChanged(e);
        }
    }

    private void setBromleyScaling(boolean b) {
        if (b) {
            this.cSubX_ = 1.0;
            this.cSubY_ = 1.2732395447351628;
        } else {
            this.cSubX_ = 0.9003163161571062;
            this.cSubY_ = 1.4142135623730951;
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.setMaxXYOverRS(this.cSubX_ * Math.PI, this.cSubY_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.lonlat2lonlatP(lon, lat);
        double latP = llP[1];
        if (latP > 89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.cSubY_ * this.rS_);
        }
        if (latP < -89.99999) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.cSubY_ * this.rS_);
        }
        double phiPRad = Math.toRadians(latP);
        double sinPhiP = Math.sin(phiPRad);
        double piSinPhiP = Math.PI * sinPhiP;
        double lonP = llP[0];
        double thetaRad = phiPRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhiP;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = Math.toRadians(lonP) * this.cSubX_ * Math.cos(thetaRad);
        double y = this.cSubY_ * Math.sin(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.invRS_ / this.cSubY_);
        double twoThetaRad = 2.0 * thetaRad;
        double phiPRad = Math.asin((twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaPRad = x * this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
        if (Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = this.lonlatP2lonlat(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        MollweideOblique mollweideOblique = this;
        synchronized (mollweideOblique) {
            double y;
            double yOverRS;
            double yFactor;
            for (int iy = 0; iy < this.dyMax_ && !((yFactor = (yOverRS = (y = (double)iy + 0.5) * this.invRS_) / this.cSubY_) > 1.0); ++iy) {
                double[] llBL;
                double[] llTR;
                double thetaRad = Math.asin(yOverRS / this.cSubY_);
                double twoThetaRad = 2.0 * thetaRad;
                double sinPhiP = (twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907;
                double phiPRad = Math.asin(sinPhiP);
                double phiP = Math.toDegrees(phiPRad);
                if (phiP > 89.99999) {
                    llTR = this.lonlatP2lonlat(0.0, phiP);
                    llBL = this.lonlatP2lonlat(0.0, -phiP);
                    this.setInvPoint(0, iy, llTR[0], llTR[1]);
                    this.setInvPoint(0, -iy - 1, llTR[0], llTR[1]);
                    break;
                }
                double xFactor = this.invRS_ / (this.cSubX_ * Math.cos(thetaRad));
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaPRad = x * xFactor;
                    if (Math.abs(lambdaPRad) > Math.PI) continue;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    phiP = Math.toDegrees(phiPRad);
                    llTR = this.lonlatP2lonlat(lambdaP, phiP);
                    double[] llBR = this.lonlatP2lonlat(lambdaP, -phiP);
                    llBL = this.lonlatP2lonlat(-lambdaP, -phiP);
                    double[] llTL = this.lonlatP2lonlat(-lambdaP, phiP);
                    this.setInvPoint(ix, iy, llTR[0], llTR[1]);
                    this.setInvPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setInvPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setInvPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }
}

