/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.PointPoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class GyorffyF
extends PointPoleProjection {
    public static final String PROJECTION_NAME = "Gy\u00f6rffy F";
    public static final int PROPERTIES = 0;
    private static final double C1 = 0.77172;
    private static final double C2 = 2.0;
    private static final double C3 = 3.26655;
    private static final double C4 = 0.00649;
    private static final double C5 = 0.88525;
    private static final double C6 = 0.0095;
    private static final double C7 = 0.00305;
    private static final double ONE_OVER_C3 = 0.3061333823146745;
    private static final double ONE_MINUS_C5 = 0.11475000000000002;
    private static final double FOUR_OVER_PI2 = 0.4052847345693511;
    private static final double MAX_X_OVER_RS = 2.5797236659481038;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public GyorffyF(int width, int height) {
        this(width, height, 0, 0);
    }

    public GyorffyF(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, 2.5797236659481038, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double lambdaRad2 = lambdaRad * lambdaRad;
        double psiRad = GyorffyF.getPsiRad(absLambdaRad, absPhiRad);
        double x = GyorffyF.getC1Term(psiRad) * absLambdaRad * (1.0 + 0.00649 * lambdaRad2);
        double y = psiRad;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double psiRad = absy * this.invRS_;
        double lambdaRad = GyorffyF.iterateLambdaRad(absx * this.invRS_, psiRad);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = this.iteratePhiRad(lambdaRad, psiRad);
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GyorffyF gyorffyF = this;
        synchronized (gyorffyF) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double psiRad = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = GyorffyF.iterateLambdaRad((x = (double)ix + 0.5) * this.invRS_, psiRad)) > Math.PI); ++ix) {
                    double phiRad = this.iteratePhiRad(lambdaRad, psiRad);
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getPsiRad(double lambdaRad, double phiRad) {
        if (phiRad < 1.0E-5) {
            return 0.0;
        }
        double phi3Term = 0.4052847345693511 * phiRad * phiRad * phiRad;
        if (lambdaRad < 1.0E-5) {
            return 0.88525 * phiRad + 0.11475000000000002 * phi3Term;
        }
        double lambdaRad2 = lambdaRad * lambdaRad;
        return 0.88525 * phiRad + 0.11475000000000002 * phi3Term + lambdaRad2 * (0.0095 + lambdaRad2 * 0.00305) * (phiRad - phi3Term);
    }

    private static double getC1Term(double psiRad) {
        return 0.77172 * Math.pow(1.0 - Math.pow(0.6366197723675814 * psiRad, 2.0), 0.3061333823146745);
    }

    private static double iterateLambdaRad(double xOverRS, double psiRad) {
        double c1Term = GyorffyF.getC1Term(psiRad);
        double lambdaRad = Math.PI * (xOverRS / 2.5797236659481038);
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double c4LambdaRad2 = 0.00649 * lambdaRad2;
            double func = c1Term * lambdaRad * (1.0 + 0.00649 * lambdaRad2) - xOverRS;
            double dfunc = c1Term * (1.0 + 3.0 * c4LambdaRad2);
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }

    private double iteratePhiRad(double lambdaRad, double psiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double lambdaTerm = lambdaRad2 * (0.0095 + lambdaRad2 * 0.00305);
        double phiRad = psiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phi3Term = 0.4052847345693511 * phiRad * phiRad2;
            double dphi3Term = 1.2158542037080533 * phiRad2;
            double func = 0.88525 * phiRad + 0.11475000000000002 * phi3Term + lambdaTerm * (phiRad - phi3Term) - psiRad;
            double dfunc = 0.88525 + 0.11475000000000002 * dphi3Term + lambdaTerm * (1.0 - dphi3Term);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

