/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Denoyer
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Denoyer Semi-Elliptical";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public Denoyer(int width, int height) {
        this(width, height, 0, 0);
    }

    public Denoyer(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLRad = Math.abs(lambdaRad);
        double lambdaRad2 = absLRad * absLRad;
        double z = (0.95 + absLRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
        double x = lambdaRad * Math.cos(z);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double absYOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absy > this.ymRS_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double phiRad = absYOverRS = absy * this.invRS_;
        double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
        double lambdaRad = 1.5707963267948966;
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double z = (0.95 + lambdaRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
            double dz = (-0.08333333333333333 + lambdaRad2 / 200.0) * phiTerm;
            double cosTerm = Math.cos(z);
            double dcosTerm = -Math.sin(z) * dz;
            double top = -(lambdaRad * cosTerm - absXOverRS);
            double bottom = cosTerm + lambdaRad * dcosTerm;
            double dLambdaRad = top / bottom;
            lambdaRad += dLambdaRad;
            if (Math.abs(dLambdaRad) < 1.0E-5) break;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Denoyer denoyer = this;
        synchronized (denoyer) {
            double phiRad;
            double y;
            block3: for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_) && !((phiRad = y * this.invRS_) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
                double lambdaRad = 0.5;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    for (int iter = 0; iter < 33; ++iter) {
                        double lambdaRad2 = lambdaRad * lambdaRad;
                        double z = (0.95 + lambdaRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
                        double dz = (-0.08333333333333333 + lambdaRad2 / 200.0) * phiTerm;
                        double cosTerm = Math.cos(z);
                        double dcosTerm = -Math.sin(z) * dz;
                        double top = -(lambdaRad * cosTerm - xOverRS);
                        double bottom = cosTerm + lambdaRad * dcosTerm;
                        double dLambdaRad = top / bottom;
                        lambdaRad += dLambdaRad;
                        if (Math.abs(dLambdaRad) < 1.0E-5) break;
                    }
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

