/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baranyi1
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baranyi I";
    public static final int PROPERTIES = 8;
    private static final double CY = 1.884956;
    private static final double CA1 = 0.517253565;
    private static final double CA2 = 0.075990887;
    private static final double B11 = 3.046174;
    private static final double B31 = 1.396263;
    private static final double B12 = 17.139269;
    private static final double B32 = 1.945432;
    private static final double JOIN_PHI = 70.558967;
    private static final double JOIN_PHIRAD = Math.toRadians(70.558967);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.884956;

    public Baranyi1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.884956);
        this.finishConstruction();
        LOGGER.trace("fPhi(pi/2) {}", (Object)Baranyi1.getFPhi(1.5707963267948966));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double y = 1.884956 * Baranyi1.getFPhi(absPhiRad);
        double x = 0.0;
        if (absPhiRad < JOIN_PHIRAD) {
            x = absLambdaRad * 0.3183098861837907 * (Math.sqrt(3.046174 - y * y) + 1.396263);
        } else {
            double sqterm = y + 1.945432;
            x = absLambdaRad * 0.3183098861837907 * Math.sqrt(17.139269 - sqterm * sqterm);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        if (phiRad < JOIN_PHIRAD) {
            lambdaRad = absXOverRS * Math.PI / (Math.sqrt(3.046174 - absYOverRS * absYOverRS) + 1.396263);
        } else {
            double sqterm = absYOverRS + 1.945432;
            lambdaRad = absXOverRS * Math.PI / Math.sqrt(17.139269 - sqterm * sqterm);
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi1 baranyi1 = this;
        synchronized (baranyi1) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double phiTerm;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = this.iteratePhiRad(yOverRS);
                if (phiRad < JOIN_PHIRAD) {
                    phiTerm = Math.PI / (Math.sqrt(3.046174 - yOverRS * yOverRS) + 1.396263);
                } else {
                    double sqterm = yOverRS + 1.945432;
                    phiTerm = Math.PI / Math.sqrt(17.139269 - sqterm * sqterm);
                }
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ * phiTerm) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getFPhi(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        return 0.517253565 * phiRad + 0.075990887 * phiRad2;
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * yOverRS / 1.884956;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = 1.884956 * (0.517253565 * phiRad + 0.075990887 * phiRad2) - yOverRS;
            double dfunc = 1.884956 * (0.517253565 + 0.151981774 * phiRad);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

