/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class AzimuthalEqualArea
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Azimuthal Equal-Area";
    public static final int PROPERTIES = 0x202040;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private static final double MAX_CLIP_ANGLE = 180.0;

    public AzimuthalEqualArea(int width, int height) {
        this(width, height, 0, 0);
    }

    public AzimuthalEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x202040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeAngleParameter(90.0, 180.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double rhoEdgeOverR = 1.4142135623730951 * Math.sqrt(1.0 - Math.cos(this.edgeAngleRad_));
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.fillCorners_ ? 2.0 * this.rS_ : this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == 1.0) {
            return 0.0;
        }
        if (cosZ == -1.0) {
            return -1.0;
        }
        return Math.sqrt(2.0 / (1.0 + cosZ));
    }

    @Override
    protected double getZRadForRho(double rho) {
        return 2.0 * Math.asin(0.5 * rho * this.invRS_);
    }
}

