/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.QuadEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Aitoff
extends QuadEllipseProjection {
    public static final String PROJECTION_NAME = "Aitoff";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public Aitoff(int width, int height) {
        this(width, height, 0, 0);
    }

    public Aitoff(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        if (lat == 0.0) {
            return new Point2D.Double((double)this.outCenterX_ + lambdaRad * this.rS_, this.outCenterY_);
        }
        double phiRad = Math.toRadians(lat);
        if (lambdaRad == 0.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - phiRad * this.rS_);
        }
        double halfLambdaRad = 0.5 * this.lonToLambdaRad(lon);
        double cosPhi = Math.cos(phiRad);
        double cosAlpha = cosPhi * Math.cos(halfLambdaRad);
        double alphaRad = Math.acos(cosAlpha);
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinAlpha = Math.sin(alphaRad);
        double cosBeta = Math.sin(phiRad) / sinAlpha;
        double sinBeta = cosPhi * Math.sin(halfLambdaRad) / sinAlpha;
        double x = 2.0 * alphaRad * sinBeta;
        double y = alphaRad * cosBeta;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double alphaRad = Math.hypot(0.5 * absXOverRS, absYOverRS);
        if (alphaRad > 1.5707963267948966) {
            return null;
        }
        double sinPhi = absYOverRS * Math.sin(alphaRad) / alphaRad;
        double phiRad = Math.asin(sinPhi);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiRad));
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Aitoff aitoff = this;
        synchronized (aitoff) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double alphaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && !((alphaRad = Math.hypot(0.5 * (x = (double)ix + 0.5), y) * this.invRS_) > 1.5707963267948966); ++ix) {
                    double lambdaRad;
                    double phiRad;
                    if (alphaRad > 1.0E-5) {
                        double sinPhi = yOverRS * Math.sin(alphaRad) / alphaRad;
                        phiRad = Math.asin(sinPhi);
                        if (phiRad > 1.5707963267948966) {
                            return;
                        }
                        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiRad));
                        if (lambdaRad > Math.PI) {
                            continue block3;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

