/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.OverlayFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Objects;

public class OverlayFilenameFilter
implements FilenameFilter {
    @Override
    public boolean accept(File dir, String name) {
        if (OverlayFilenameFilter.isOverlayName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isOverlayName(File f) {
        Objects.requireNonNull(f, "File is null.");
        return OverlayFilenameFilter.isOverlayName(f.getName());
    }

    public static boolean isOverlayName(String fname) {
        Objects.requireNonNull(fname, "File name is null.");
        String lcname = fname.toLowerCase();
        for (String extension : OverlayFactory.getValidExtensions()) {
            if (!lcname.endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutlineName(File f) {
        Objects.requireNonNull(f, "File is null.");
        return OverlayFilenameFilter.isOutlineName(f.getName());
    }

    public static boolean isOutlineName(String fname) {
        Objects.requireNonNull(fname, "File name is null.");
        String lcname = fname.toLowerCase();
        for (String extension : OverlayFactory.getOutlineExtensions()) {
            if (!lcname.endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

