/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;

public class NcGridderTimeLat
extends NcGridderXY {
    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        double[][] yBounds = yAxis.getBounds();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastY = numYs - 1;
        boolean northToSouth = yVals[0] > yVals[1];
        int northY = northToSouth ? 0 : lastY;
        int southY = northToSouth ? lastY : 0;
        double northYVal = yVals[northY];
        double southYVal = yVals[southY];
        double northEdge = northToSouth ? yBounds[0][0] : yBounds[lastY][1];
        double southEdge = northToSouth ? yBounds[lastY][1] : yBounds[0][0];
        double npExtend = northYVal + (northEdge - northYVal) * 1.75;
        double spExtend = southYVal + (southEdge - southYVal) * 1.75;
        int[] srcCol = new int[this.gridWidth_];
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            if (this.rowYY_[j] >= northYVal && this.rowYY_[j] <= npExtend) {
                srcRow[j] = -9000;
                continue;
            }
            if (this.rowYY_[j] <= southYVal && this.rowYY_[j] >= spExtend) {
                srcRow[j] = -8000;
                continue;
            }
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yVals[jj] && this.rowYY_[j] < yVals[jj + 1]) && (!(this.rowYY_[j] <= yVals[jj]) || !(this.rowYY_[j] > yVals[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs - 1; ++ii) {
                if (!(this.colXX_[i] >= xVals[ii] && this.colXX_[i] < xVals[ii + 1]) && (!(this.colXX_[i] <= xVals[ii]) || !(this.colXX_[i] > xVals[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double yPct;
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ >= 0) {
                yPct = (this.rowYY_[j] - yVals[rowJ]) / (yVals[rowJP1] - yVals[rowJ]);
            } else if (rowJ == -9000) {
                yPct = 0.5;
            } else {
                if (rowJ != -8000) continue;
                yPct = 0.5;
            }
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                int colI = srcCol[i];
                int colIP1 = srcCol[i] + 1;
                if (colI == -1) continue;
                double xPct = (this.colXX_[i] - xVals[colI]) / (xVals[colIP1] - xVals[colI]);
                if (rowJ >= 0) {
                    valTL = nca2D.valueAt(colI, rowJ);
                    valTR = nca2D.valueAt(colIP1, rowJ);
                    valBL = nca2D.valueAt(colI, rowJP1);
                    valBR = nca2D.valueAt(colIP1, rowJP1);
                } else if (rowJ == -9000) {
                    valTL = nca2D.valueAt(colI, northY);
                    valTR = nca2D.valueAt(colIP1, northY);
                    valBL = valTL;
                    valBR = valTR;
                } else {
                    if (rowJ != -8000) continue;
                    valTL = nca2D.valueAt(colI, southY);
                    valTR = nca2D.valueAt(colIP1, southY);
                    valBL = valTL;
                    valBR = valTR;
                }
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }
}

