/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.math.PointLL;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public interface NcArrayLonLatAuxiliary {
    public NcAxis getXAxis();

    public NcAxis getYAxis();

    public double valueAt(int var1, int var2);

    public double longitudeAt(int var1, int var2);

    public double latitudeAt(int var1, int var2);

    public PointLL lonLatAt(int var1, int var2);

    public double[][] cornerLonLats(int var1, int var2);

    public boolean doCellsAbut(int var1, int var2, int var3, int var4);

    public static VariableDS[] getCoordinateVars(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("reqRank {}", (Object)reqRank);
        VariableDS[] varsCS = NcArrayLonLatAuxiliary.getCoordinateVarsCS(ncd, varDS, reqRank);
        VariableDS[] varsNoCS = NcArrayLonLatAuxiliary.getCoordinateVarsNoCS(ncd, ncg, varDS, reqRank);
        if (varsCS == null && varsNoCS == null) {
            logger.trace("No lon-lat vars found");
            return null;
        }
        if (varsCS == null) {
            logger.trace("Lon-lat vars found in attribute but not in CS.");
            return varsNoCS;
        }
        if (varsNoCS == null) {
            logger.trace("Lon-lat vars found in CS but not in attribute.");
            return varsCS;
        }
        if (varsNoCS[0].equals(varsCS[0]) && varsNoCS[1].equals(varsCS[1])) {
            logger.trace("Lon-lat vars in attribute equal those in CS.");
            return varsCS;
        }
        logger.trace("Lon-lat vars in attribute do NOT match those in CS.");
        logger.trace("Returning those from attribute.");
        return varsNoCS;
    }

    public static VariableDS[] getCoordinateVarsCS(NcDataset ncd, VariableDS varDS, int reqRank) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        List csList = varDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            logger.trace("No coordinate system in list");
            return null;
        }
        logger.trace("CS list has size {}", (Object)csList.size());
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        if (cs == null) {
            return null;
        }
        logger.trace("cs[0] {}", (Object)cs);
        logger.trace("Found a coordinate system to work with");
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        logger.trace("CS reports lonax {}, latax {}", (Object)(lonax != null ? 1 : 0), (Object)(latax != null ? 1 : 0));
        if (lonax == null || latax == null) {
            return null;
        }
        logger.trace("lonax {}, latax {}", (Object)lonax.getShortName(), (Object)latax.getShortName());
        if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, lonax, latax, reqRank)) {
            return new VariableDS[]{lonax, latax};
        }
        logger.trace("lon/lat vars did not validate");
        return null;
    }

    public static VariableDS[] getCoordinateVarsNoCS(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String[] tokens = NcUtils.parseCoordinatesAttribute(varDS);
        logger.trace("has tokens {}", (Object)(tokens != null ? 1 : 0));
        if (tokens == null || tokens.length == 0) {
            VariableDS[] vars;
            if (ncd.isHdfEos()) {
                vars = NcArrayLonLatAuxiliary.getCoordinateVarsNoTokens1(ncd, varDS, reqRank);
                logger.trace("A {}", (Object)(vars != null ? 1 : 0));
                if (vars != null) {
                    return vars;
                }
            }
            logger.trace("B {}", (Object)((vars = NcArrayLonLatAuxiliary.getCoordinateVarsNoTokens2(ncd, ncg, varDS, reqRank)) != null ? 1 : 0));
            if (vars == null && !ncd.isHdfEos()) {
                vars = NcArrayLonLatAuxiliary.getCoordinateVarsNoTokens1(ncd, varDS, reqRank);
            }
            logger.trace("C {}", (Object)(vars != null ? 1 : 0));
            return vars;
        }
        VariableDS[] vars = NcArrayLonLatAuxiliary.getCoordinateVarsAtPaths(ncd, varDS, tokens);
        if (vars != null) {
            if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                return vars;
            }
            logger.trace("lon/lat vars did not validate (A)");
        }
        vars = null;
        Group grp = varDS.getParentGroup();
        vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grp, tokens);
        if (vars != null) {
            if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                return vars;
            }
            logger.trace("lon/lat vars did not validate (B)");
        }
        vars = null;
        Group pgrp = grp.getParentGroup();
        if (pgrp == null) {
            return null;
        }
        vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, pgrp, tokens);
        if (vars != null) {
            if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                return vars;
            }
            logger.trace("lon/lat vars did not validate (C)");
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsNoTokens1(NcDataset ncd, VariableDS varDS, int reqRank) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("");
        Group grp = varDS.getParentGroup();
        String grpPath = grp.getFullName();
        VariableDS[] vars = NcArrayLonLatAuxiliary.getLLCoordinateVarsInGroup(ncd, grp);
        if (vars != null) {
            if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                return vars;
            }
            logger.trace("Lon and lat vars did not validate (A)");
        }
        vars = null;
        Group pgrp = grp.getParentGroup();
        if (pgrp == null) {
            return null;
        }
        vars = NcArrayLonLatAuxiliary.getLLCoordinateVarsInGroup(ncd, pgrp);
        if (vars != null) {
            if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                logger.trace("Founds vars in parent group");
                return vars;
            }
            logger.trace("Lon and lat vars did not validate (B)");
        }
        vars = null;
        String altgrpPath = null;
        if (grpPath.endsWith("Data_Fields")) {
            altgrpPath = grpPath.replace("Data_Fields", "Geolocation_Fields");
        } else if (grpPath.endsWith("geophysical_data")) {
            altgrpPath = grpPath.replace("geophysical_data", "navigation_data");
        } else if (grpPath.endsWith("observation_data")) {
            altgrpPath = grpPath.replace("observation_data", "geolocation_data");
        }
        logger.trace("altgrpPath {}", (Object)altgrpPath);
        if (altgrpPath != null) {
            vars = NcArrayLonLatAuxiliary.getLLCoordinateVarsInGroup(ncd, altgrpPath);
            logger.trace("vars found? {}", (Object)(vars != null ? 1 : 0));
            if (vars != null) {
                if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
                    return vars;
                }
                logger.trace("Lon and lat vars did not validate (C)");
            }
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsNoTokens2(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (ncg == null) {
            logger.trace("Not in a data grouping?");
            return null;
        }
        NcVariable[] cvars = ncg.getCoordinateVars();
        if (cvars == null) {
            logger.trace("No cvars reported in group");
            return null;
        }
        if (cvars.length < 2) {
            logger.trace("Group cvars array is too small");
            return null;
        }
        ArrayList<VariableDS> lonvars = new ArrayList<VariableDS>(10);
        ArrayList<VariableDS> latvars = new ArrayList<VariableDS>(10);
        for (NcVariable ncvar : cvars) {
            int[] shape;
            VariableDS njvar;
            NcCoordinateVarType cvarType = ncvar.getCoordinateVarType();
            if (cvarType == NcCoordinateVarType.LONGITUDE) {
                njvar = (VariableDS)ncvar.getObject();
                if (njvar.getRank() != reqRank) continue;
                shape = njvar.getShape();
                lonvars.add(njvar);
                continue;
            }
            if (cvarType != NcCoordinateVarType.LATITUDE || (njvar = (VariableDS)ncvar.getObject()).getRank() != reqRank) continue;
            shape = njvar.getShape();
            latvars.add(njvar);
        }
        if (lonvars.size() < 1 || latvars.size() < 1) {
            return null;
        }
        logger.trace("Found lonvars {}, latvars {}", (Object)lonvars.size(), (Object)latvars.size());
        for (VariableDS lonvar : lonvars) {
            for (VariableDS latvar : latvars) {
                if (!NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, lonvar, latvar, reqRank)) continue;
                logger.trace("got a match!");
                return new VariableDS[]{lonvar, latvar};
            }
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsAtPaths(NcDataset ncd, VariableDS varDS, String ... paths) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("-- {} tokens", (Object)paths.length);
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        for (String token : paths) {
            VariableDS tokenVar = ncd.getVariableDS(token);
            if (tokenVar == null) {
                logger.trace("-- Could not find var at path '{}'", (Object)token);
                continue;
            }
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcUtils.getUnitsStr(tokenVar);
            if (NcUnitUtils.isDegreesEast(unitsStr) || "longitude".equals(lcname) || "grid_lon".equals(lcname)) {
                lonVarDS = tokenVar;
                continue;
            }
            if (!NcUnitUtils.isDegreesNorth(unitsStr) && !"latitude".equals(lcname) && !"grid_lat".equals(lcname)) continue;
            latVarDS = tokenVar;
        }
        if (lonVarDS == null || latVarDS == null) {
            logger.trace("-- Lon and/or lat vars not found");
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    public static VariableDS[] getLLCoordinateVarsInGroup(NcDataset ncd, Group grp) {
        String grpPath = grp.getFullName();
        return NcArrayLonLatAuxiliary.getLLCoordinateVarsInGroup(ncd, grpPath);
    }

    public static VariableDS[] getLLCoordinateVarsInGroup(NcDataset ncd, String grpPath) {
        VariableDS[] vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grpPath, "Longitude", "Latitude");
        if (vars == null) {
            vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grpPath, "longitude", "latitude");
        }
        if (vars == null) {
            vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grpPath, "GRID_LON", "GRID_LAT");
        }
        if (vars == null) {
            vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grpPath, "grid_lon", "grid_lat");
        }
        return vars;
    }

    public static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, Group njgrp, String ... tokens) {
        if (njgrp == null) {
            return null;
        }
        String grpPath = njgrp.getFullName();
        return NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, grpPath, tokens);
    }

    public static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, String grpPath, String ... tokens) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (tokens[0].lastIndexOf(47) >= 0) {
            return null;
        }
        String[] tokens2 = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i] = grpPath.length() > 0 ? grpPath + "/" + tokens[i] : tokens[i];
        }
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        for (String token : tokens2) {
            VariableDS tokenVar = ncd.getVariableDS(token);
            if (tokenVar == null) continue;
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcUtils.getUnitsStr(tokenVar);
            if (NcUnitUtils.isDegreesEast(unitsStr) || "longitude".equals(lcname) || "grid_lon".equals(lcname)) {
                lonVarDS = tokenVar;
                continue;
            }
            if (NcUnitUtils.isDegreesNorth(unitsStr) || "latitude".equals(lcname) || "grid_lat".equals(lcname)) {
                latVarDS = tokenVar;
                continue;
            }
            logger.trace("-- Found var '{}' but it appears to be neither lon or lat", (Object)token);
        }
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    public static boolean validateCoordinateVars(NcDataset ncd, VariableDS varDS, VariableDS lonvar, VariableDS latvar, int reqRank) {
        Objects.requireNonNull(ncd, "NcDataset cannot be null.");
        Objects.requireNonNull(varDS, "VarDS cannot be null.");
        Objects.requireNonNull(lonvar, "Lon CV cannot be null.");
        Objects.requireNonNull(latvar, "Lat CV cannot be null.");
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.trace("Testing lonvar {}, latvar {}", (Object)lonvar.getShortName(), (Object)latvar.getShortName());
        String lonvarSName = lonvar.getShortName().toLowerCase();
        if (lonvarSName.indexOf("corner") > -1) {
            return false;
        }
        String lonvarLName = NcUtils.getLongName(lonvar);
        if (lonvarLName.indexOf("corner") > -1) {
            return false;
        }
        if (reqRank < 2 || reqRank > 3) {
            throw new IllegalArgumentException("Required coordinate var rank must be 2 or 3.");
        }
        int varRank = varDS.getRank();
        if (varRank < reqRank) {
            logger.trace("Var {} has rank {} rather than req rank {}", varDS.getShortName(), varRank, reqRank);
            return false;
        }
        if (lonvar.getRank() != reqRank) {
            logger.trace("Lon var is not required rank {}", (Object)reqRank);
            return false;
        }
        if (latvar.getRank() != reqRank) {
            logger.trace("Lat var is not required rank {}", (Object)reqRank);
            return false;
        }
        int[] lonshape = lonvar.getShape();
        int[] latshape = latvar.getShape();
        for (int i = 0; i < reqRank; ++i) {
            Dimension dd2;
            if (lonshape[i] != latshape[i]) {
                logger.trace("Lon/lat var dim {} lengths do not agree", (Object)i);
                return false;
            }
            Dimension dd1 = lonvar.getDimension(i);
            if (!dd1.equals(dd2 = latvar.getDimension(i))) {
                logger.trace("Lon/lat var dims {} are not equal", (Object)i);
                return false;
            }
            int didx = NcUtils.findDimensionIndex(varDS, dd1);
            if (didx >= 0) continue;
            if (ncd.isAquaModis() && dd1.getName().equals("pixel_control_points")) {
                Dimension ddd;
                logger.trace("Aqua-MODIS!");
                didx = NcUtils.findDimensionIndex(varDS, "pixels_per_line");
                if (didx > -1 && (ddd = varDS.getDimension(didx)).getLength() == dd1.getLength()) {
                    logger.trace("-- match");
                    continue;
                }
            }
            logger.trace("Data var does not share dimension {}", (Object)i, (Object)dd1.getShortName());
            return false;
        }
        if (reqRank == 2) {
            return lonshape[0] >= 2 && lonshape[1] >= 2;
        }
        int[] cvarIndices = NcArrayLonLatAuxiliary.getGridVarDimIndices3D(ncd, lonvar);
        if (cvarIndices == null) {
            logger.trace("Call to getGridVarDimIndices3D failed.");
            return false;
        }
        int xdim = cvarIndices[0];
        int ydim = cvarIndices[1];
        if (lonshape[xdim] < 2 || lonshape[ydim] < 2) {
            return false;
        }
        logger.trace("Apparently validates. Whew!");
        return true;
    }

    public static int[] getGridVarDimIndices3D(NcDataset ncd, VariableDS cvarDS) {
        Objects.requireNonNull(ncd, "NcDataset cannot be null.");
        Objects.requireNonNull(cvarDS, "CvarDS cannot be null.");
        if (cvarDS.getRank() != 3) {
            throw new IllegalArgumentException("Gridding var must be 3D");
        }
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        int xDimIdx = -1;
        int yDimIdx = -1;
        int oDimIdx = -1;
        for (int i = 0; i < 3; ++i) {
            Attribute longA;
            Dimension dd = cvarDS.getDimension(i);
            String dname = dd.getShortName();
            String lcname = dname.toLowerCase();
            if ("band".equalsIgnoreCase(lcname) || "channel".equalsIgnoreCase(lcname) || "fov".equalsIgnoreCase(lcname) || "sensor".equalsIgnoreCase(lcname) || "time".equalsIgnoreCase(lcname) || "nbin".equalsIgnoreCase(lcname) || lcname.contains("band") || lcname.contains("flag") || lcname.contains("quality")) {
                oDimIdx = i;
                logger.trace("* Found oDimIdx {}", (Object)oDimIdx);
                continue;
            }
            if (lcname.contains("x-coordinate") || lcname.matches(".*across.swath.*") || lcname.matches(".*across.track.*") || lcname.contains("across-track")) {
                xDimIdx = i;
                logger.trace("* Found xdim via lcname {}", (Object)i);
                continue;
            }
            if (lcname.contains("y-coordinate") || lcname.matches(".*along.swath.*") || lcname.matches(".*along.track.*") || lcname.contains("along-track")) {
                yDimIdx = i;
                logger.trace("* Found ydim via lcname {}", (Object)i);
                continue;
            }
            VariableDS cv = ncd.getCoordinateVariable(dd);
            if (cv != null && (longA = cv.findAttribute("long_name")) != null) {
                String longName = longA.getStringValue().toLowerCase();
                if (longName.contains("x-coordinate") || longName.matches(".*across.swath.*") || longName.matches(".*across.track.*") || longName.contains("across-track")) {
                    xDimIdx = i;
                    logger.trace("* Found xdim via long_name {}", (Object)i);
                    continue;
                }
                if (longName.contains("y-coordinate") || longName.matches(".*along.swath.*") || longName.matches(".*along.track.*") || longName.contains("along-track")) {
                    yDimIdx = i;
                    logger.trace("* Found ydim via long_name {}", (Object)i);
                    continue;
                }
            }
            if (xDimIdx < 0 || yDimIdx < 0) {
                if (lcname.contains("xdim") || lcname.contains("xtrack") || lcname.contains("btrack") || lcname.contains("numcells") || lcname.contains("azsize") || lcname.contains("scanline")) {
                    logger.trace("* Found xdim via dim name {}, {}", (Object)i, (Object)lcname);
                    xDimIdx = i;
                    continue;
                }
                if (lcname.contains("ydim") || lcname.contains("ytrack") || lcname.contains("atrack") || lcname.contains("track") || lcname.contains("numrows") || lcname.contains("rasize") || lcname.contains("ground_pixel")) {
                    logger.trace("* Found ydim via dim name {}, {}", (Object)i, (Object)lcname);
                    yDimIdx = i;
                    continue;
                }
            }
            logger.trace("* Dim {} {} matches no obvious name or attr", (Object)i, (Object)dname);
        }
        if (oDimIdx < 0 && (xDimIdx < 0 || yDimIdx < 0)) {
            logger.trace("No *DimIdxs found; looking for shortest dim");
            oDimIdx = 0;
            if (cvarDS.getDimension(1).getLength() < cvarDS.getDimension(0).getLength()) {
                oDimIdx = 1;
            }
            if (cvarDS.getDimension(2).getLength() < cvarDS.getDimension(1).getLength()) {
                oDimIdx = 2;
            }
        }
        logger.trace("* After scan : x {}, y {}, o {}", xDimIdx, yDimIdx, oDimIdx);
        if (xDimIdx > -1 && yDimIdx > -1) {
            oDimIdx = 3 - xDimIdx - yDimIdx;
        } else if (oDimIdx > -1) {
            if (oDimIdx == 0) {
                xDimIdx = 2;
                yDimIdx = 1;
            } else if (oDimIdx == 1) {
                xDimIdx = 2;
                yDimIdx = 0;
            } else {
                xDimIdx = 1;
                yDimIdx = 0;
            }
        } else {
            return null;
        }
        logger.trace("* Reporting! x {}, y {}, o {}", xDimIdx, yDimIdx, oDimIdx);
        return new int[]{xDimIdx, yDimIdx, oDimIdx};
    }
}

