/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcGroup;
import gov.nasa.giss.data.nc.NcStructure;
import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public abstract class NcDataGrouping
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Group njgroup_;
    private NcVariable[] cvars_;

    public NcDataGrouping(NcDataGrouping parent, Group group) {
        super(parent);
        this.njgroup_ = group;
    }

    protected void setGrouping(Group group) {
        this.njgroup_ = group;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    protected void initChildren() {
        LOGGER.trace("{}", (Object)this.getShortName());
        this.initAllChildren();
        this.initVisibleChildren();
        this.scanForCoordinateVars();
    }

    private void initAllChildren() {
        String fname;
        if (this.njgroup_ == null) {
            LOGGER.error("Backing NJ Group is not set.");
            return;
        }
        this.childNameList_.clear();
        this.allChildren_ = new ArrayList(50);
        for (Group o : this.njgroup_.getGroups()) {
            fname = o.getFullName();
            this.childNameList_.add(fname);
            try {
                NcGroup ncg = new NcGroup(this, o);
                this.allChildren_.add(ncg);
            }
            catch (Exception exc) {
                LOGGER.error("Could not create NCGroup");
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
        for (Variable var : this.njgroup_.getVariables()) {
            fname = var.getFullName();
            this.childNameList_.add(fname);
            try {
                NcStructure ncstruct;
                if (var instanceof SequenceDS) {
                    SequenceDS njseqDS = (SequenceDS)var;
                    ncstruct = new NcStructure(this, njseqDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof StructureDS) {
                    StructureDS njstructDS = (StructureDS)var;
                    ncstruct = new NcStructure(this, njstructDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof VariableDS) {
                    VariableDS njvarDS = (VariableDS)var;
                    NcVariable ncv = new NcVariable(this, njvarDS);
                    this.allChildren_.add(ncv);
                    continue;
                }
                LOGGER.warn("Unexpected data class {}, {}", (Object)var.getShortName(), (Object)var.getClass());
            }
            catch (Exception exc) {
                LOGGER.error("Exception constructing {}, {}", (Object)var.getShortName(), (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
    }

    private void initVisibleChildren() {
        this.clear();
        if (this.njgroup_ == null) {
            return;
        }
        NcVarVisibility vclass = this.getVarVisibility();
        for (NcDataNode child : this.allChildren_) {
            if (child instanceof NcGroup || child instanceof NcStructure) {
                this.addSorted(child);
                continue;
            }
            if (child instanceof NcVariable) {
                NcVariable ncv = (NcVariable)child;
                if (vclass != NcVarVisibility.ALL && !ncv.isGriddable2DGeo() && (vclass != NcVarVisibility.GRIDDABLE || !ncv.isGriddable2D())) continue;
                this.addSorted(child);
                continue;
            }
            LOGGER.warn("Unexpected NcType {}", (Object)child.getClass());
        }
    }

    private void scanForCoordinateVars() {
        ArrayList<NcVariable> cvarList = new ArrayList<NcVariable>(50);
        for (NcDataNode node : this.allChildren_) {
            NcVariable ncvar;
            NcCoordinateVarType cvarType;
            if (!(node instanceof NcVariable) || (cvarType = (ncvar = (NcVariable)node).getCoordinateVarType()) == NcCoordinateVarType.NONE || cvarType == NcCoordinateVarType.OTHER) continue;
            cvarList.add(ncvar);
        }
        this.cvars_ = cvarList.toArray(new NcVariable[0]);
    }

    @Override
    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarVisibility vclass) {
        NcVariable ncv;
        super.setVisibleVarClass(model, vclass);
        if (this.njgroup_ == null) {
            LOGGER.warn("Backing NJ Group is not set.");
            return;
        }
        TreeTableNode[] children = this.getChildren();
        if (vclass == NcVarVisibility.GEOREF || vclass == NcVarVisibility.GRIDDABLE) {
            for (int i = children.length - 1; i >= 0; --i) {
                NcDataNode node = (NcDataNode)children[i];
                if (!(node instanceof NcVariable) || (ncv = (NcVariable)node).isGriddable2DGeo() || ncv.isTrajectory() || vclass == NcVarVisibility.GRIDDABLE && ncv.isGriddable()) continue;
                this.remove(node);
                if (model == null) continue;
                model.nodeRemoved(this, i, node);
            }
        }
        if (vclass == NcVarVisibility.ALL || vclass == NcVarVisibility.GRIDDABLE) {
            for (NcDataNode child : this.allChildren_) {
                try {
                    if (!(child instanceof NcVariable) || this.isChildVisible(ncv = (NcVariable)child)) continue;
                    boolean makeVis = false;
                    if (vclass == NcVarVisibility.ALL) {
                        makeVis = true;
                    } else if (ncv.isGriddable2DGeo() || ncv.isTrajectory()) {
                        makeVis = true;
                    } else if (vclass == NcVarVisibility.GRIDDABLE && ncv.isGriddable()) {
                        makeVis = true;
                    }
                    if (!makeVis) continue;
                    int index = this.addSorted(ncv);
                    if (model == null) continue;
                    model.nodeInserted(this, index, ncv);
                }
                catch (Exception exc) {
                    LOGGER.error(exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }

    private boolean isChildVisible(NcDataNode node) {
        TreeTableNode[] children = this.getChildren();
        if (children == null || children.length == 0) {
            return false;
        }
        String name = node.getName();
        for (TreeTableNode child : children) {
            boolean matches = name.equals(child.getName());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public NcVariable[] getCoordinateVars() {
        return this.cvars_;
    }
}

