/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.Objects;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPSession;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.RuntimeConfigParser;

public final class NcConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String UNIDATA_DIR = ".unidata";
    private static final String NJCONFIG_XML = "nj22Config.xml";
    private static final String GRIB1_LOOKUP = "grib1lookuptable.lst";
    private static File cacheDir_;
    private static boolean devoMode_;
    private static boolean gribInitted_;
    private static boolean grib1Strict_;
    private static boolean triedNj22config_;

    public static void setDevo() {
        LOGGER.info("Setting NC devo mode");
        devoMode_ = true;
    }

    public static boolean isDevo() {
        return devoMode_;
    }

    public static void disableRemotePreload() {
        DODSNetcdfFile.setPreload(false);
    }

    public static void initHttpClient(String agent, CredentialsProvider cprov) {
        block3: {
            HTTPSession.setGlobalUserAgent(agent);
            if (cprov == null) {
                return;
            }
            try {
                HTTPSession.setGlobalCredentialsProvider(cprov);
            }
            catch (Exception exc) {
                LOGGER.error("Unable to set credentials provider: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
    }

    public static void initCache(String appname, String domain) {
        if (cacheDir_ != null) {
            return;
        }
        String qAppname = (domain + "." + appname).toLowerCase();
        cacheDir_ = FileUtils.getAppCacheDirectory(appname, qAppname);
        if (cacheDir_ == null) {
            LOGGER.warn("Got null creating cache directory object {}", (Object)cacheDir_);
            return;
        }
        String cpath = cacheDir_.getAbsolutePath();
        try {
            if (!cacheDir_.exists()) {
                cacheDir_.mkdirs();
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Cache dir {} does not exist and cannot be created.", (Object)cpath);
            LOGGER.warn("Exception reported was: {}", (Object)exc.toString());
            LOGGER.warn("This may block opening GRIB files and cause other problems.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return;
        }
        DiskCache.setRootDirectory(cpath);
        DiskCache.setCachePolicy(true);
        DiskCache2 dc2 = new DiskCache2(cpath, false, 60, 50);
        dc2.setAlwaysUseCache(true);
        GribIndexCache.setDiskCache2(dc2);
    }

    public static void clearCache() {
        block2: {
            DiskCache.cleanCache(new Date(), new StringBuilder());
            try {
                FileUtils.deleteDirectoryContents(cacheDir_);
            }
            catch (Exception exc) {
                LOGGER.warn("Error clearing cache directory {}", (Object)cacheDir_);
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    public static boolean isCLibraryPresent() {
        return NetcdfClibrary.isLibraryPresent();
    }

    public static boolean readNj22Config() {
        LOGGER.debug("Already checked for config file? {}", (Object)triedNj22config_);
        if (triedNj22config_) {
            return false;
        }
        triedNj22config_ = true;
        String homeDir = null;
        try {
            homeDir = System.getProperty("user.home");
        }
        catch (Exception exc) {
            LOGGER.warn("Exception getting user.home property: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
        if (homeDir == null) {
            LOGGER.debug("Null reported for user.home.");
            return false;
        }
        File udir = new File(homeDir, UNIDATA_DIR);
        File f = new File(udir, NJCONFIG_XML);
        LOGGER.debug("Looking for {}", (Object)f.getAbsolutePath());
        if (f.exists()) {
            LOGGER.debug("An nj22Config file was found");
            StringBuilder sb = new StringBuilder();
            try (FileInputStream fis = new FileInputStream(f);){
                RuntimeConfigParser.read(fis, sb);
            }
            catch (IOException exc) {
                LOGGER.warn("IOException reading nj22Config, {}", (Object)exc.getMessage());
            }
            catch (Exception exc) {
                LOGGER.warn("Exception reading nj22Config, {}, {}", (Object)exc.getClass().getSimpleName(), (Object)exc.getMessage());
                LOGGER.debug("RuntimeConfigParser errlog reported:");
                LOGGER.debug(sb.toString());
            }
            return true;
        }
        LOGGER.info("No nj22Config file found");
        return false;
    }

    public static void initGribHandling(boolean strict) {
        block10: {
            if (gribInitted_) {
                LOGGER.warn("GRIB handling has already been initialized.)");
                return;
            }
            grib1Strict_ = strict;
            File gissSupportDir = FileUtils.getGISSAppSupportDirectory();
            File tabdir = new File(gissSupportDir, "gribtab");
            if (!tabdir.exists()) {
                LOGGER.debug("GRIBTAB support directory does not exist.");
                return;
            }
            if (!tabdir.isDirectory()) {
                LOGGER.warn("GRIBTAB support path exists but is not a directory.");
                return;
            }
            if (strict) {
                Grib1ParamTables.setStrict(true);
            }
            File fff = null;
            try {
                fff = new File(tabdir, GRIB1_LOOKUP);
            }
            catch (Exception exc) {
                LOGGER.warn("Error creating GRIB-1 lookup list File object {}", exc);
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return;
            }
            if (!(fff instanceof File) || !fff.exists()) {
                LOGGER.debug("GRIB-1 lookup list file does nto exist.");
                return;
            }
            try {
                Grib1ParamTables.addParameterTableLookup(fff.getAbsolutePath());
                LOGGER.info("Opened GRIBTAB lookup list.");
            }
            catch (Exception exc) {
                LOGGER.warn("Exception accessing GRIB-1 lookup list {}", (Object)exc.getMessage());
                if (!LOGGER.isTraceEnabled()) break block10;
                exc.printStackTrace();
            }
        }
    }

    public static boolean isGrib1Strict() {
        return grib1Strict_;
    }

    public static boolean openGrib1Table(File f, int center, int subcenter, int version) {
        Objects.requireNonNull(f, "Null File passed");
        if (!f.exists()) {
            throw new IllegalArgumentException("No file matching File object");
        }
        try {
            Grib1ParamTables.addParameterTable(center, subcenter, version, f.getAbsolutePath());
            return true;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception accessing GRIB-1 lookup table {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
    }

    private NcConfig() {
    }
}

