/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.util.Base64EncoderStream;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;

public class CachedImageHandlerBase64Encoder
extends DefaultCachedImageHandler {
    public CachedImageHandlerBase64Encoder() {
        this.setImageCacher(new ImageCacher.Embedded());
    }

    @Override
    public Element createElement(SVGGeneratorContext generatorContext) {
        Element imageElement = generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
        return imageElement;
    }

    @Override
    public String getRefPrefix() {
        return "";
    }

    @Override
    protected AffineTransform handleTransform(Element imageElement, double x, double y, double srcWidth, double srcHeight, double dstWidth, double dstHeight, SVGGeneratorContext generatorContext) {
        AffineTransform af = new AffineTransform();
        double hRatio = dstWidth / srcWidth;
        double vRatio = dstHeight / srcHeight;
        af.translate(x, y);
        if (hRatio != 1.0 || vRatio != 1.0) {
            af.scale(hRatio, vRatio);
        }
        if (!af.isIdentity()) {
            return af;
        }
        return null;
    }

    @Override
    public void encodeImage(BufferedImage buf, OutputStream os) throws IOException {
        Base64EncoderStream b64Encoder = new Base64EncoderStream(os);
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        writer.writeImage(buf, b64Encoder);
        b64Encoder.close();
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension size, ColorModel cm) {
        BufferedImage image;
        if (cm == null || cm.getColorSpace().isCS_sRGB()) {
            image = new BufferedImage(size.width, size.height, this.getDefaultBufferedImageType());
        } else {
            WritableRaster raster = cm.createCompatibleWritableRaster(size.width, size.height);
            image = new BufferedImage(cm, raster, false, null);
        }
        return image;
    }

    @Override
    protected int getDefaultBufferedImageType() {
        return 2;
    }
}

