/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGRed;
import io.sf.carte.echosvg.ext.awt.image.renderable.DeferRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.RedRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.Any2sRGBRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FormatRed;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.MagicNumberRegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    @Override
    public Filter handleStream(InputStream inIS, ParsedURL origURL, boolean needRawData) {
        Object[] errParam;
        String errCode;
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        final boolean raw = needRawData;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{"PNG", origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{"PNG"};
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                Filter filt;
                try {
                    PNGDecodeParam param = new PNGDecodeParam();
                    param.setExpandPalette(true);
                    if (raw) {
                        param.setPerformGammaCorrection(false);
                    } else {
                        param.setPerformGammaCorrection(true);
                        param.setDisplayExponent(2.2f);
                    }
                    CachableRed cr = new PNGRed(is, param);
                    dr.setBounds(new Rectangle2D.Double(0.0, 0.0, cr.getWidth(), cr.getHeight()));
                    cr = new Any2sRGBRed(cr);
                    cr = new FormatRed(cr, GraphicsUtil.sRGB_Unpre);
                    WritableRaster wr = (WritableRaster)cr.getData();
                    ColorModel cm = cr.getColorModel();
                    BufferedImage image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    cr = GraphicsUtil.wrap(image);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = ImageTagRegistry.getBrokenLinkImage(PNGRegistryEntry.this, errCode, errParam);
                }
                catch (ThreadDeath td) {
                    Filter filt2 = ImageTagRegistry.getBrokenLinkImage(PNGRegistryEntry.this, errCode, errParam);
                    dr.setSource(filt2);
                    throw td;
                }
                catch (Throwable t) {
                    filt = ImageTagRegistry.getBrokenLinkImage(PNGRegistryEntry.this, errCode, errParam);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

