/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGEncodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImageEncoder;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.PNGImageWriterParams;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class PNGImageWriter
implements ImageWriter {
    @Override
    public void writeImage(RenderedImage image, OutputStream out) throws IOException {
        this.writeImage(image, out, null);
    }

    @Override
    public void writeImage(RenderedImage image, OutputStream out, ImageWriterParams params) throws IOException {
        PNGEncodeParam param = null;
        if (params != null) {
            Integer level = params.getCompressionLevel();
            if (level != null) {
                param = PNGEncodeParam.getDefaultEncodeParam(image);
                param.setCompressionLevel(level);
            }
            if (params instanceof PNGImageWriterParams) {
                param = this.encodePNGParam(image, (PNGImageWriterParams)params, param);
            }
        }
        PNGImageEncoder encoder = new PNGImageEncoder(out, param);
        encoder.encode(image);
    }

    private PNGEncodeParam encodePNGParam(RenderedImage image, PNGImageWriterParams params, PNGEncodeParam param) {
        if (params.isTextSet()) {
            if (param == null) {
                param = PNGEncodeParam.getDefaultEncodeParam(image);
            }
            param.setText(params.getText());
        }
        if (params.isCompressedTextSet()) {
            if (param == null) {
                param = PNGEncodeParam.getDefaultEncodeParam(image);
            }
            param.setCompressedText(params.getCompressedText());
        }
        if (params.isInternationalTextSet()) {
            if (param == null) {
                param = PNGEncodeParam.getDefaultEncodeParam(image);
            }
            param.setInternationalText(params.getInternationalText());
        }
        return param;
    }

    @Override
    public String getMIMEType() {
        return "image/png";
    }
}

