/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2019-2023 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::specieTransferTemperatureFvPatchScalarField

Description
    This is a temperature boundary condition for a specie-transferring wall.

    This condition must be used in conjunction with mass-fraction boundary
    conditions derived from specieTransferMassFractionFvPatchScalarField, and a
    specieTransferVelocity condition for the velocity.

    This condition sums the species' energy fluxes generated by the
    mass-fraction conditions, and uses this total to set the flux of energy
    into or out of the domain.

Usage
    \table
        Property | Description                | Req'd? | Default
        phi      | Name of the flux field     | no     | phi
        U        | Name of the velocity field | no     | U
    \endtable

    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            specieTransferTemperature;
        value           $internalField;
    }
    \endverbatim

See also
    Foam::specieTransferMassFractionFvPatchScalarField
    Foam::specieTransferVelocityFvPatchScalarField

SourceFiles
    specieTransferTemperatureFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef specieTransferTemperatureFvPatchScalarField_H
#define specieTransferTemperatureFvPatchScalarField_H

#include "mixedEnergyCalculatedTemperatureFvPatchScalarField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
         Class specieTransferTemperatureFvPatchScalarField Declaration
\*---------------------------------------------------------------------------*/

class specieTransferTemperatureFvPatchScalarField
:
    public mixedEnergyCalculatedTemperatureFvPatchScalarField
{
    // Private Data

        //- Name of the flux field
        const word phiName_;

        //- Name of the velocity field
        const word UName_;


public:

    //- Runtime type information
    TypeName("specieTransferTemperature");


    // Constructors

        //- Construct from patch, internal field and dictionary
        specieTransferTemperatureFvPatchScalarField
        (
            const fvPatch&,
            const DimensionedField<scalar, volMesh>&,
            const dictionary&,
            const bool readValue = true
        );

        //- Construct by mapping given fixedValueTypeFvPatchField
        //  onto a new patch
        specieTransferTemperatureFvPatchScalarField
        (
            const specieTransferTemperatureFvPatchScalarField&,
            const fvPatch&,
            const DimensionedField<scalar, volMesh>&,
            const fieldMapper&
        );

        //- Disallow copy without setting internal field reference
        specieTransferTemperatureFvPatchScalarField
        (
            const specieTransferTemperatureFvPatchScalarField&
        ) = delete;

        //- Copy constructor setting internal field reference
        specieTransferTemperatureFvPatchScalarField
        (
            const specieTransferTemperatureFvPatchScalarField&,
            const DimensionedField<scalar, volMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalarField> clone
        (
            const DimensionedField<scalar, volMesh>& iF
        ) const
        {
            return tmp<fvPatchScalarField>
            (
                new specieTransferTemperatureFvPatchScalarField
                (
                    *this,
                    iF
                )
            );
        }


    // Member Functions

        // Evaluation functions

            //- Return the flux of energy
            const tmp<scalarField> phiHep() const;

            //- Update the coefficients associated with the patch field
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //


#endif

// ************************************************************************* //
