/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::zoneGenerators::invert

Description
    A zoneGenerator which initially selects all the elements in the zones and
    then removes the elements from the given list of zoneGenerators

    This is equivalent to using the zoneGenerator::difference with
    \c all as the first zoneGenerator in the list.

Usage
    \table
        Property     | Description             | Required | Default value
        type         | Type: invert            | yes      |
        name         | Name of the zone        | no       | zoneGenerator name
        zoneType     | Type of zone            | no       | all the zone types
        moveUpdate   | Switch to update after mesh motion | no | false
    \endtable
    These options are followed by a list of any number of zoneGenerators which
    can either generate the zones locally or return zones from the lists of
    zones held by the mesh using the zoneGenerators::lookup zoneGenerator.

    Each zoneGenerator returns a zoneSet containing a pointZone and/or a
    cellZone and/or a faceZone, the zoneGenerators::invert operation
    combines each of the zone types unless the \c zoneType is specified in which
    case only the zones of that type are combined.

    A cellZone named \c notConeOrAnnulus containing all the cells mesh except
    those with centres inside the predefined \c cone1 cellZone which is
    looked-up from the cellZoneList or the locally defined annulus is be
    generated by
    \verbatim
        notConeOrAnnulus
        {
            type        invert;

            cone1
            {
                zoneType        cell;
            }

            annulus1
            {
                type        annulus;
                zoneType    cell;

                point1      (-0.0075 0 -1);
                point2      (-0.003 0.0025 1);
                outerRadius 0.002;
                innerRadius 0.001;
            }
        }
    \endverbatim

See also
    zoneGenerators::Union
    zoneGenerators::difference
    zoneGenerators::intersection
    zoneGeneratorList

SourceFiles
    invert.C

\*---------------------------------------------------------------------------*/

#ifndef invert_zoneGenerator_H
#define invert_zoneGenerator_H

#include "zoneGeneratorList.H"
#include "union.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace zoneGenerators
{

/*---------------------------------------------------------------------------*\
                              Class invert Declaration
\*---------------------------------------------------------------------------*/

class invert
:
    public Union
{

public:

    //- Runtime type information
    TypeName("invert");


    // Constructors

        //- Construct from dictionary
        invert
        (
            const word& name,
            const polyMesh& mesh,
            const dictionary& dict
        );


    //- Destructor
    virtual ~invert();


    // Member Functions

        virtual zoneSet generate() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace zoneGenerators
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
