/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::zoneGenerators::difference

Description
    A zoneGenerator which selects the elements in the first zones generated by
    the given list of zoneGenerators and removes the elements which are in
    subsequent zones

    An difference faceZones is oriented if the first faceZones is oriented,
    otherwise the returned faceZone is unoriented.

Usage
    \table
        Property     | Description             | Required | Default value
        type         | Type: difference        | yes      |
        name         | Name of the zone        | no       | zoneGenerator name
        zoneType     | Type of zone            | no       | all the zone types
        moveUpdate   | Switch to update after mesh motion | no | false
    \endtable
    These options are followed by a list of any number of zoneGenerators which
    can either generate the zones locally or return zones from the lists of
    zones held by the mesh using the zoneGenerators::lookup zoneGenerator.  The
    resultant zones are initialised by the first zoneGenerator in the list and
    then the zones generated by subsequent zoneGenerator are subtracted
    from them.

    Each zoneGenerator returns a zoneSet containing a pointZone and/or a
    cellZone and/or a faceZone, the zoneGenerators::difference operation
    combines each of the zone types unless the \c zoneType is specified in which
    case only the zones of that type are combined.

    A cellZone named \c coneNotAnnulus containing the with centres inside the
    predefined \c cone1 which is looked-up from the cellZoneList less the
    cells in locally defined annulus is be generated by
    \verbatim
        notConeOrAnnulus
        {
            type        difference;

            cone1;

            annulus1
            {
                type        annulus;
                zoneType    cell;

                point1      (-0.0075 0 -1);
                point2      (-0.003 0.0025 1);
                outerRadius 0.002;
                innerRadius 0.001;
            }
        }
    \endverbatim

See also
    zoneGenerators::Union
    zoneGenerators::intersection
    zoneGeneratorList

SourceFiles
    difference.C

\*---------------------------------------------------------------------------*/

#ifndef difference_zoneGenerator_H
#define difference_zoneGenerator_H

#include "zoneGeneratorList.H"
#include "union.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace zoneGenerators
{

/*---------------------------------------------------------------------------*\
                              Class difference Declaration
\*---------------------------------------------------------------------------*/

class difference
:
    public Union
{

public:

    //- Runtime type information
    TypeName("difference");


    // Constructors

        //- Construct from dictionary
        difference
        (
            const word& name,
            const polyMesh& mesh,
            const dictionary& dict
        );


    //- Destructor
    virtual ~difference();


    // Member Functions

        virtual zoneSet generate() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace zoneGenerators
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
