/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2025 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::growthFvScalarFieldSource

Description
    Base class for source conditions which create a growth source terms in the
    size group equations or related secondary property equations of a
    population balance.

SourceFiles
    growthFvScalarFieldSource.C

\*---------------------------------------------------------------------------*/

#ifndef growthFvScalarFieldSource_H
#define growthFvScalarFieldSource_H

#include "fvFieldSources.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                  Class growthFvScalarFieldSource Declaration
\*---------------------------------------------------------------------------*/

class growthFvScalarFieldSource
:
    public fvScalarFieldSource
{
public:

    // Constructors

        //- Inherit constructors
        using fvScalarFieldSource::fvScalarFieldSource;


    // Member Functions

        //- Return the source value. Not Implemented.
        virtual tmp<DimensionedField<scalar, volMesh>> sourceValue
        (
            const fvSource& model,
            const DimensionedField<scalar, volMesh>& source
        ) const;

        //- Return the source coefficients for exchange with the groups below
        //  and above this group
        virtual Pair<tmp<DimensionedField<scalar, volMesh>>> sourceCoeffs
        (
            const fvSource& model
        ) const = 0;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
