/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2011-2024 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::XiEqModels::instability

Description
    Model for the equilibrium flame wrinkling \c XiEq including a simple
    correction for the wrinkling generated by flame instability.

SourceFiles
    instability.C

\*---------------------------------------------------------------------------*/

#ifndef instability_H
#define instability_H

#include "XiEqModel.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace XiEqModels
{

/*---------------------------------------------------------------------------*\
                         Class instability Declaration
\*---------------------------------------------------------------------------*/

class instability
:
    public XiEqModel
{
    // Private Data

        //- Equilibrium Xi due to instability only
        dimensionedScalar XiEqIn_;

        //- Instability length-scale
        dimensionedScalar lambdaIn_;


        //- Equilibrium Xi model due to all other effects
        autoPtr<XiEqModel> XiEqModel_;


protected:

        //- Update coefficients from given dictionary
        virtual bool readCoeffs(const dictionary& dict);


public:

    //- Runtime type information
    TypeName("instability");


    // Constructors

        //- Construct from components
        instability
        (
            const dictionary& dict,
            const psiuMulticomponentThermo& thermo,
            const fluidThermoThermophysicalTransportModel& turbulence,
            const volScalarField& Su
        );

        //- Disallow default bitwise copy construction
        instability(const instability&) = delete;


    //- Destructor
    virtual ~instability();


    // Member Functions

        //- Return the flame-wrinkling XiEq
        virtual tmp<volScalarField> XiEq() const;

        //- Return the flame diffusivity
        virtual tmp<volScalarField> Db() const;


    // Member Operators

        //- Disallow default bitwise assignment
        void operator=(const instability&) = delete;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace XiEqModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
