/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2021-2024 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "realTime.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace userTimes
{
    defineTypeNameAndDebug(real, 0);
    addToRunTimeSelectionTable(userTime, real, dictionary);
}
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::userTimes::real::real(const dictionary& controlDict)
:
    userTime(controlDict)
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::userTimes::real::~real()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::scalar Foam::userTimes::real::userTimeToTime(const scalar tau) const
{
    return tau;
}


Foam::scalar Foam::userTimes::real::timeToUserTime(const scalar t) const
{
    return t;
}


Foam::word Foam::userTimes::real::unitName() const
{
    return "s";
}


const Foam::unitConversion& Foam::userTimes::real::units() const
{
    static const unitConversion unitSeconds(dimTime, 0, 0, 1);
    return unitSeconds;
}


bool Foam::userTimes::real::read(const dictionary& controlDict)
{
    return true;
}


// ************************************************************************* //
