/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2018-2024 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "generalisedNewtonian.H"
#include "volFields.H"
#include "surfaceFields.H"
#include "fvcGrad.H"
#include "fvcDiv.H"
#include "fvmLaplacian.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace laminarModels
{

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class BasicMomentumTransportModel>
generalisedNewtonian<BasicMomentumTransportModel>::generalisedNewtonian
(
    const alphaField& alpha,
    const rhoField& rho,
    const volVectorField& U,
    const surfaceScalarField& alphaRhoPhi,
    const surfaceScalarField& phi,
    const viscosity& viscosity
)
:
    linearViscousStress<laminarModel<BasicMomentumTransportModel>>
    (
        typeName,
        alpha,
        rho,
        U,
        alphaRhoPhi,
        phi,
        viscosity
    ),

    viscosityModel_
    (
        generalisedNewtonianViscosityModel::New
        (
            this->coeffDict(),
            viscosity,
            U
        )
    )
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class BasicMomentumTransportModel>
bool generalisedNewtonian<BasicMomentumTransportModel>::read()
{
    viscosityModel_->read(this->coeffDict());

    return true;
}


template<class BasicMomentumTransportModel>
tmp<volScalarField>
generalisedNewtonian<BasicMomentumTransportModel>::nuEff() const
{
    return volScalarField::New
    (
        this->groupName("nuEff"),
        viscosityModel_->nu()
    );
}


template<class BasicMomentumTransportModel>
tmp<scalarField>
generalisedNewtonian<BasicMomentumTransportModel>::nuEff
(
    const label patchi
) const
{
    return viscosityModel_->nu(patchi);
}


template<class BasicMomentumTransportModel>
void generalisedNewtonian<BasicMomentumTransportModel>::predict()
{
    viscosityModel_->correct();
    laminarModel<BasicMomentumTransportModel>::predict();
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace laminarModels
} // End namespace Foam

// ************************************************************************* //
