/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2025 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Global
    centralCourantNo

Description
    Calculates the mean and maximum wave speed based Courant Numbers.

\*---------------------------------------------------------------------------*/

if (mesh.nInternalFaces())
{
    scalarField sumAmaxSf(fvc::surfaceSum(amaxSf)().primitiveField());

    if (LTS)
    {
        const volScalarField& rDeltaT = trDeltaT.cref();
        const scalarField fldCo
        (
            sumAmaxSf/mesh.V().field()/rDeltaT.primitiveField()
        );

        auto CoLimits = gMinMax(fldCo);

        minCoNum = 0.5*CoLimits.min();
        CoNum = 0.5*CoLimits.max();
        meanCoNum = 0.5*gAverage(fldCo);

        Info<< "Courant Numbers: "
            << "min = " << minCoNum << ", "
            << "average = " << meanCoNum << ", "
            << "max = " << CoNum
            << endl;
    }
    else
    {
        CoNum = 0.5*gMax(sumAmaxSf/mesh.V().field())*runTime.deltaTValue();

        meanCoNum =
            0.5*(gSum(sumAmaxSf)/gSum(mesh.V().field()))*runTime.deltaTValue();

        Info<< "Mean and max Courant Numbers = "
            << meanCoNum << " " << CoNum << endl;
    }
}

// ************************************************************************* //
