#!/bin/bash
#####################################################################
#                                                                   #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com     #
#                                                                   #
#  All rights reserved.                                             #
#                                                                   #
#####################################################################

RunDir=${0%nxdebugcollect.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=2

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

COMMAND_SERVER="${NX_ROOT}/bin/nxserver"

if test -x "/usr/bin/date"; then
  COMMAND_DATE="/usr/bin/date"
elif test -x "/usr/sbin/date"; then
  COMMAND_DATE="/usr/sbin/date"
elif test -x "/bin/date"; then
  COMMAND_DATE="/bin/date"
elif test -x "/sbin/date"; then
  COMMAND_DATE="/sbin/date"
elif test -x "/usr/local/bin/date"; then
  COMMAND_DATE="/usr/local/bin/date"
elif test -x "/usr/local/sbin/date"; then
  COMMAND_DATE="/usr/local/sbin/date"
else
  errorCommandNotFound "date" "1"
fi

if test -x "/usr/bin/hostname"; then
  COMMAND_HOSTNAME="/usr/bin/hostname"
elif test -x "/usr/sbin/hostname"; then
  COMMAND_HOSTNAME="/usr/sbin/hostname"
elif test -x "/bin/hostname"; then
  COMMAND_HOSTNAME="/bin/hostname"
elif test -x "/sbin/hostname"; then
  COMMAND_HOSTNAME="/sbin/hostname"
elif test -x "/usr/local/bin/hostname"; then
  COMMAND_HOSTNAME="/usr/local/bin/hostname"
elif test -x "/usr/local/sbin/hostname"; then
  COMMAND_HOSTNAME="/usr/local/sbin/hostname"
else
  errorCommandNotFound "hostname" "1"
fi

if test -x "/usr/bin/env"; then
  COMMAND_ENV="/usr/bin/env"
elif test -x "/usr/sbin/env"; then
  COMMAND_ENV="/usr/sbin/env"
elif test -x "/bin/env"; then
  COMMAND_ENV="/bin/env"
elif test -x "/sbin/env"; then
  COMMAND_ENV="/sbin/env"
elif test -x "/usr/local/bin/env"; then
  COMMAND_ENV="/usr/local/bin/env"
elif test -x "/usr/local/sbin/env"; then
  COMMAND_ENV="/usr/local/sbin/env"
else
  errorCommandNotFound "env" "1"
fi

CURRENTDATE=`$COMMAND_DATE +"%d.%m.%Y-%H.%M"`

if test -z "$CURRENTDATE"; then
  CURRENTDATE="nodate"
fi

HOSTNAME=`$COMMAND_HOSTNAME`

if test -z "$HOSTNAME"; then
  HOSTNAME="nohostname"
fi

FILE_NAME="${NX_ROOT}/var/tmp/Server-logs-$HOSTNAME-$CURRENTDATE"

if ! test -d "${NX_ROOT}/var/tmp/"; then
  $COMMAND_MKDIR -p "${NX_ROOT}/var/tmp/"
fi

exec ${COMMAND_ENV} NX_USER=yes "${COMMAND_SERVER}" --debug --collect "${FILE_NAME}" --progress
