#!perl
######################################################################
#                                                                    #
#  Copyright (c) 2012, 2025 NoMachine, http://www.nomachine.com.    #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

my $weight       = -1;

if (! @ARGV)
{
  #
  # Return empty message and exit.
  #

  print "\n";
  exit 1;
}


my @nodeList = split(/#/,$ARGV[0]);

my %selectedNodesHash = ();

foreach my $node (@nodeList)
{
  if (! $node)
  {
    next;
  }

  #
  #  $nodeName            - it's the host:port pair qualifying the node
  #                         as it is in output of 'nxserver --nodelist' command
  #  $nodeWeight          - it's the weight, a numeric value, attributed to the node.
  #  $nodeSessionRunning  - it's the number of sessions connected to the node.
  #  $nodeConnectionLimit - it's the maximum number of connections allowed on that node.
  #  $nodeLoadAvg         - it's the CPU load average value on the node, retrieved from
  #                         /proc/loadavg.
  #  $nodeAvailableMemory - it's the amount of free memory (RAM) on the node.
  #

  my ($nodeName, $nodeWeight, $nodeSessionRunning, $nodeConnectionLimit) = split(/,/,$node);

  if (($nodeConnectionLimit != 0) && ($nodeSessionRunning >= $nodeConnectionLimit))
  {
    #
    # Ignore the node if maximum number of connections is reached for that 
    # node. Unlimited connections are allowed on that node if variable
    # $nodeConnectionLimit is set to 0. 
    #

    next;
  }

  #
  # Set weight.
  #

  $selectedNodesHash{"$nodeName"} = $nodeWeight - $nodeSessionRunning;
}

if (! keys %selectedNodesHash)
{
  print "\n";
  exit 1;
}

#
# Sort selected nodes by weight.
#

my @sortedNodesArray = sort { $selectedNodesHash{$b} <=> $selectedNodesHash{$a} } keys %selectedNodesHash;

#
# Convert selected nodes array to list string with '#' separator.
#

my $sortedNodesString = join("#", @sortedNodesArray);

#
# Return selected nodes list to nxserver.
#

print "$sortedNodesString\n";

exit 0;
