#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

PARAMS_COUNT=5

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

if test -x "/sbin/ip"; then
  COMMAND_IP="/sbin/ip"
else
  ${COMMAND_ECHO} "NX> 500 Error: ip command not found."
  exit 1
fi

if test -x "/bin/sed"; then
  COMMAND_SED="/bin/sed"
else
  ${COMMAND_ECHO} "NX> 500 Error: sed command not found."
  exit 1
fi

#
# User parameters.
#

for par in "${@:3}"; do
  if test "x${par}" = "x"; then
    ${COMMAND_ECHO} "NX> 500 Error: one of parameters is empty."

    exit 1
  fi
done

OTHER_TAP_IP="${3}"
OTHER_GATEWAY="${4}"
TAP_INTERFACE="${5}"

HEADER_RESOLV="# Start configuration of NoMachine VPN."

NAMESERVER="nameserver ${OTHER_GATEWAY}"

FOOTER_RESOLV="# End configuration of NoMachine VPN."

#
# Directory to backup current/restore old settings.
#

NX_VPN_TEMP="${NX_ROOT}/var/tmp/nxvpn"

if [ ! -d "${NX_VPN_TEMP}" ]; then
  ${COMMAND_MKDIR} -p "${NX_VPN_TEMP}"
fi

RESOLV="/etc/resolv.conf"
NX_RESOLV="${NX_VPN_TEMP}/nxtemp_resolv.conf_${TAP_INTERFACE}"
NX_RESOLV_TMP="${NX_VPN_TEMP}/nxtemp_resolv.conf_${TAP_INTERFACE}_tmp"

#
# Delete our configuration from resolv.conf.
#

deleteConf()
{
  #
  # Deleting all lines from header to footer.
  #

  ${COMMAND_SED} -i "/^${HEADER_RESOLV}$/,/^${FOOTER_RESOLV}$/d" $RESOLV
}

addConf()
{
  ${COMMAND_CP} ${RESOLV} ${NX_RESOLV}
 
  ${COMMAND_ECHO} ${HEADER_RESOLV} > ${NX_RESOLV_TMP}
  ${COMMAND_ECHO} ${NAMESERVER} >> ${NX_RESOLV_TMP}
  ${COMMAND_ECHO} ${FOOTER_RESOLV} >> ${NX_RESOLV_TMP}
  ${COMMAND_CAT} ${RESOLV} >> ${NX_RESOLV_TMP}

  ${COMMAND_CP} ${NX_RESOLV_TMP} ${RESOLV}

  ${COMMAND_RM} -f ${NX_RESOLV_TMP}
}