#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxrenice.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

CFGPRIORITY=$($COMMAND_AWK '/^DisplayServerPriority/ {print $2}' ${NX_ROOT}/etc/node.cfg)

locateCommand COMMAND_RENICE renice

PRIORITY="-20"

if test "${CFGPRIORITY}" = "high"; then
  PRIORITY="-10"
elif test "${CFGPRIORITY}" = "normal"; then
  PRIORITY="0"
elif test "${CFGPRIORITY}" = "low"; then
  PRIORITY="19"
fi

PID="$3"

${COMMAND_RENICE} -n ${PRIORITY} -p ${PID}

