#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxquotaadd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=4
PARAMS_COUNT_MIN=8

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

COMMAND_SETQUOTA="/usr/sbin/setquota"

if test ! -x ${COMMAND_SETQUOTA}; then
  errorCommandNotFound "${COMMAND_SETQUOTA}" "1"
fi

if test $# -eq 4; then
  if [ "x$3" != "x" ];
  then
    GUESTNAME="$3"
  fi

  if [ "x$4" != "x" ];
  then
    PROTONAME="$4"
  fi

  ${COMMAND_SETQUOTA} -u -p ${PROTONAME} ${GUESTNAME} -a
  exit $?
fi

if test $# -eq 8; then
  if test "x$3" != "x"; then
    GUESTNAME="$3"
  fi

  if test "$8" != "all"; then
    FS=$8
  else
    FS="-a"
  fi

  ${COMMAND_SETQUOTA} -u ${GUESTNAME} $4 $5 $6 $7 ${FS}
  exit $?
fi

if test $# -eq 6; then
  if test "x$3" != "x"; then
    GUESTNAME="$3"
  fi

  if test "$6" != "all"; then
    FS=$6
  else
    FS="-a"
  fi

  ${COMMAND_SETQUOTA} -T -u ${GUESTNAME} $4 $5 ${FS}
  exit $?
fi
