#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxenvironmentget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh


isRunByServerOrNode

PROCESS_ID="$3"

if [ -e "/bin/cat" ];
then
  COMMAND_CAT="/bin/cat"
elif [ -e "/usr/bin/cat" ];
then
  COMMAND_CAT="/usr/bin/cat"
else
  echo "ERROR: cat command not found"
  exit 1
fi

if test "x${PROCESS_ID}" = "x"; then
  errorMsg "Missing process id parameter." "1"
fi

if [ -e "/proc/${PROCESS_ID}/environ" ];
then
  ENVIRONMENT="/proc/${PROCESS_ID}/environ"
else
  errorMsg "Can not find environment for process ${PROCESS_ID}." "1"
fi

${COMMAND_CAT} ${ENVIRONMENT}
