fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'windrose.txt')
ncol = numasciicol(fn)
nrow = numasciirow(fn)
a = asciiread(fn,shape=(nrow,ncol))
ws=a[:,0]
wd=a[:,1]

n = 16
wsbins = arange(0., 21.1, 4)
cols = makecolors(['k','y','r','b','g'], alpha=0.7)
rtickloc = [0.05,0.1,0.15,0.18]
ax, bars = windrose(wd, ws, n, wsbins, rmax=0.18, colors=cols,
    rtickloc=rtickloc, width=0.5)
colorbar(bars, shrink=0.6, vmintick=True, vmaxtick=True, xshift=10,
    label='m/s', labelloc='bottom')
ax.set_xtick_font(name='Times New Roman')
title('Windrose example')
antialias(True)