fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'pm10.txt')
df = DataFrame.read_table(fn, format='%3f')
ws = df['WS'].values
wd = df['WD'].values
pm10 = df['PM10'].values
N = len(ws)
x = arange(N)
y = ones(N)
y1 = y - 0.6

plot(x, y, color='k')
q = quiver(x, y, wd, ws, pm10, isuv=False, size=40)
quiverkey(q, 0.2, 0.7, 5, '5 m/s')
colorbar(q, shrink=0.8, label=r'$\mu g/m^3$')
plot(x, y1, color='k')
barbs(x, y1, wd, ws, pm10, isuv=False, size=10)
xlim(-5, 55)
ylim(0.3, 1.1)