lats_all = array([43.78,36.05, 40.1, 38.48, 39.8, 39.1, 38.9, 30.65, 34.43, 34.78, 22.82])
lons_all = array([87.62,103.88, 113.33, 106.22, 116.47, 117.17, 121.63, 104.03, 108.97, 113.68, 108.35])
x = arange(90, 130.1, 10)
y = arange(20, 44, 10)
gdata = griddata((lons_all, lats_all), lons_all, xi=(x, y), 
    method='inside_count', centerpoint=True)[0]

axesm()
geoshow('cn_province', edgecolor='k')
layer = imshow(x, y, gdata, cmap='BlueRed')
colorbar(layer)
xx, yy = meshgrid(x, y)
gdata = gdata.astype('float')
gdata[0,0] = nan
gridshow(x, y, gdata, edgecolor='r', facecolor=None, zorder=2)
scatter(x, y, gdata, facecolor=None, edgecolor='c')
scatter(lons_all,lats_all,lons_all, color='k', marker='*')
xlim(80, 140)
ylim(10, 50)