from mipylib.numeric import stats

x = arange(0, 3, 0.01)
aa = [0.5, 1, 2, 4, 8]
ss = ['-b', '-r', '-c', '-g', '-m']

#PDF
subplot(1,2,1)
for a,s in zip(aa,ss):
    y = stats.levy.pdf(x, 0, a)
    plot(x, y, s, linewidth=2, label=r'c = %.1f' % a)
#grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 1)
xlim(0, 3)
title('PDF')

#CDF
subplot(1,2,2)
for a,s in zip(aa,ss):
    y = stats.levy.cdf(x, 0, a)
    plot(x, y, s, linewidth=2, label=r'c = %.1f' % a)
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 0.7)
xlim(0, 3)
title('CDF')

suptitle('Levy distribution')