print 'Open data files...'
f_air = addfile('D:/Temp/nc/air.2011.nc')
f_uwnd = addfile('D:/Temp/nc/uwnd.2011.nc')
f_vwnd = addfile('D:/Temp/nc/vwnd.2011.nc')

print 'Read data array...'
tidx = 173    # Jun 23, 2011
t = f_air.gettime(tidx)
lidx = 0    # 1000 hPa
air = f_air['air'][tidx,lidx,:,:]
uwnd = f_uwnd['uwnd'][tidx,lidx,:,:]
vwnd = f_vwnd['vwnd'][tidx,lidx,:,:]
lon = f_air['lon'][:]
lat = f_air['lat'][:]
lon, lat = meshgrid(lon, lat)

# Calculate
print 'Calculate...'
dtx = meteolib.cdiff(air, 1)
dty = meteolib.cdiff(air, 0)
dx = meteolib.cdiff(lon, 1) * pi / 180
dy = meteolib.cdiff(lat, 0) * pi / 180
tadv = -1*((uwnd*dtx)/(cos(lat*pi/180)*dx)+vwnd*dty/dy)/6.37e6

#Plot
print 'Plot...'
axesm()
geoshow('country', edgecolor='black')
layer = contourf(tadv, cmap='grads_rainbow')
title('Temperature advection (' + t.strftime('%Y-%m-%d') + ')')
colorbar(layer)
xlim(0, 360)
ylim(-90, 90)
xticks(arange(0, 361, 30))
yticks(arange(-90, 91, 30))