f_air = addfile('D:/Temp/nc/air.2011.nc')
f_rhum = addfile('D:/Temp/nc/rhum.2011.nc')
levels = f_air['level'][:]
z = 0
t0 = f_air['air'][0,z,::-1]
rh = f_rhum['rhum'][0,z,::-1]
prs = levels[z]
es = 6.1078*exp(17.2693882*(t0-273.16)/(t0-35.86))
qq = rh*(0.62197*es/(prs-0.378*es))/100.
e = prs*qq/(0.62197+qq)+1e-10
tlcl = 55.0+2840.0/(3.5*log(t0)-log(e)-4.805)
theta = t0*pow((1000/prs),(0.2854*(1.0-0.28*qq)))
eqt = theta*exp(((3376./tlcl)-2.54)*qq*(1.0+0.81*qq))
thse = eqt-273.15
#Plot
axesm()
geoshow('country')
levs = arange(250, 361, 10)
layer = contour(eqt, levs)
clabel(layer)
colorbar(layer)
title('pseudo-equivalent potential temperature')