#Read data
fn = os.path.join(migl.get_sample_folder(), 'NetCDF', 'sst_ndjfm_anom.nc')
f = addfile(fn)
sst = f['sst'][:]
lons = f['longitude'][:]
lats = f['latitude'][:]

# Create an EOF solver to do the EOF analysis. Square-root of cosine of
# latitude weights are applied before the computation of EOFs.
coslat = np.cos(np.deg2rad(lats))
wgts = np.sqrt(coslat)[..., np.newaxis]
solver = meteolib.EOF(sst, weights=wgts)

# Retrieve the leading EOF, expressed as the correlation between the leading
# PC time series and the input SST anomalies at each grid point, and the
# leading PC time series itself.
eof1 = solver.eofs_correlation(neofs=1)
pc1 = solver.pcs(npcs=1, pcscaling=1)
e1 = solver.variance_fraction(1)[0]

#Plot
subplot(2,1,1,axestype='map')
geoshow('continent', facecolor='w')
levs = arange(-0.8, 1, 0.2)
layer = contourf(lons, lats, eof1.squeeze(), levs, extend='both', 
    cmap='matlab_jet', smooth=False, zorder=0)
yticks(arange(-20, 61, 40))
colorbar(layer)
title('EOF mode 1 expressed as correlation (%.1f%%)' % (e1*100))

subplot(2,1,2)
years = range(1962, 2012)
plot(years, pc1, color='b', linewidth=2, antialias=True)
y = zeros(len(years))
plot(years, y, color='k')
xlim(1962, 2011)
ylim(-3,3)
xticks(arange(1970,2011,10))
xlabel('Year')
ylabel('Normalized Units')
title('PC1 Time Series')

#savefig('D:/Temp/figure/eof_elnino.png', 500, 600, dpi=300)