/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.trajectory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteothink.trajstat.trajectory.Location;

public class TrajControl {
    private LocalDateTime _startTime = LocalDateTime.now();
    private List<Location> _locations = new ArrayList<Location>();
    private int _runHours = -24;
    private int _vertical = 0;
    private float _topOfModel = 10000.0f;
    private List<String> _meteoFiles = new ArrayList<String>();
    private String _outPath;
    private String _trajFileName;

    public LocalDateTime getStartTime() {
        return this._startTime;
    }

    public void setStartTime(LocalDateTime value) {
        this._startTime = value;
    }

    public List<Location> getLocations() {
        return this._locations;
    }

    public void setLocations(List<Location> value) {
        this._locations = value;
    }

    public int getRunHours() {
        return this._runHours;
    }

    public void setRunHours(int value) {
        this._runHours = value;
    }

    public int getVertical() {
        return this._vertical;
    }

    public void setVertical(int value) {
        this._vertical = value;
    }

    public float getTopOfModel() {
        return this._topOfModel;
    }

    public void setTopOfModel(float value) {
        this._topOfModel = value;
    }

    public List<String> getMeteoFiles() {
        return this._meteoFiles;
    }

    public void setMeteoFiles(List<String> value) {
        this._meteoFiles = value;
    }

    public String getOutPath() {
        return this._outPath;
    }

    public void setOutPath(String value) {
        this._outPath = value.substring(value.length() - 1).equals(File.separator) ? value : value + File.separator;
    }

    public String getTrajFileName() {
        return this._trajFileName;
    }

    public void setTrajFileName(String value) {
        this._trajFileName = value;
    }

    public void setLocation(Location loc) {
        this._locations.clear();
        this._locations.add(loc);
    }

    public void setLocation(String loc) {
        this.setLocation(new Location(loc));
    }

    public void addLocation(Location loc) {
        this._locations.add(loc);
    }

    public void addLocation(String loc) {
        this._locations.add(new Location(loc));
    }

    public void loadControlFile(String fileName) {
        try {
            BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
            String stimeStr = sr.readLine().trim();
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yy MM dd HH");
            this._startTime = LocalDateTime.parse(stimeStr, format);
            int locnum = Integer.parseInt(sr.readLine());
            this._locations = new ArrayList<Location>();
            for (int i = 0; i < locnum; ++i) {
                String[] dataArray = sr.readLine().trim().split("\\s+");
                Location loc = new Location();
                loc.latitude = Float.parseFloat(dataArray[0]);
                loc.longitude = Float.parseFloat(dataArray[1]);
                loc.height = Float.parseFloat(dataArray[2]);
                this._locations.add(loc);
            }
            this._runHours = Integer.parseInt(sr.readLine());
            this._vertical = Integer.parseInt(sr.readLine());
            this._topOfModel = Float.parseFloat(sr.readLine());
            int metFileNum = Integer.parseInt(sr.readLine());
            this._meteoFiles = new ArrayList<String>();
            for (int i = 0; i < metFileNum; ++i) {
                String path = sr.readLine().trim();
                String fn = sr.readLine().trim();
                this._meteoFiles.add(path + fn);
            }
            this._outPath = sr.readLine().trim();
            this._trajFileName = sr.readLine().trim();
            sr.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TrajControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TrajControl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveControlFile(String fileName) {
        BufferedWriter sw = null;
        try {
            int i;
            sw = new BufferedWriter(new FileWriter(new File(fileName)));
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yy MM dd HH");
            sw.write(format.format(this._startTime));
            sw.newLine();
            sw.write(String.valueOf(this._locations.size()));
            sw.newLine();
            for (i = 0; i < this._locations.size(); ++i) {
                sw.write(this._locations.get(i).toString());
                sw.newLine();
            }
            sw.write(String.valueOf(this._runHours));
            sw.newLine();
            sw.write(String.valueOf(this._vertical));
            sw.newLine();
            sw.write(String.valueOf(this._topOfModel));
            sw.newLine();
            sw.write(String.valueOf(this._meteoFiles.size()));
            sw.newLine();
            for (i = 0; i < this._meteoFiles.size(); ++i) {
                File file = new File(this._meteoFiles.get(i));
                sw.write(file.getParent() + File.separator);
                sw.newLine();
                sw.write(file.getName());
                sw.newLine();
            }
            sw.write(this._outPath);
            sw.newLine();
            sw.write(this._trajFileName);
        }
        catch (IOException ex) {
            Logger.getLogger(TrajControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TrajControl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

