/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteothink.trajstat.forms.FrmStartLocations;
import org.meteothink.trajstat.trajectory.Location;
import org.meteothink.trajstat.trajectory.TrajConfig;
import org.meteothink.trajstat.trajectory.TrajUtil;

public class FrmTrajMonth
extends JDialog {
    private TrajConfig _trajConfig = new TrajConfig();
    private String _pluginPath;
    private ButtonGroup buttonGroup1;
    private JButton jButton_AddMeteoFiles;
    private JButton jButton_Calculate;
    private JButton jButton_Clear;
    private JButton jButton_Combine;
    private JButton jButton_Convert;
    private JButton jButton_ExecuteFile;
    private JButton jButton_LoadConfig;
    private JButton jButton_Locations;
    private JButton jButton_OutPath;
    private JButton jButton_SaveConfig;
    private JCheckBox jCheckBox_MultiLocations;
    private JLabel jLabel_YearMonth;
    private JLabel jLabel_YearMonth1;
    private JLabel jLabel_YearMonth2;
    private JLabel jLabel_YearMonth3;
    private JLabel jLabel_YearMonth4;
    private JLabel jLabel_YearMonth5;
    private JLabel jLabel_YearMonth6;
    private JLabel jLabel_YearMonth7;
    private JLabel jLabel_YearMonth8;
    private JList jList_MeteoFiles;
    private JPanel jPanel_Duration;
    private JPanel jPanel_Vertical;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButton_Data;
    private JRadioButton jRadioButton_Dens;
    private JRadioButton jRadioButton_Isen;
    private JRadioButton jRadioButton_Isob;
    private JRadioButton jRadioButton_Sigma;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextField jTextField_EndDay;
    private JTextField jTextField_ExcuteFile;
    private JTextField jTextField_OutputPath;
    private JTextField jTextField_RunHours;
    private JTextField jTextField_StartDay;
    private JTextField jTextField_StartHours;
    private JTextField jTextField_StartLocation;
    private JTextField jTextField_TopOfModel;
    private JTextField jTextField_YearMonth;

    public FrmTrajMonth(Frame parent, boolean modal, String pluginPath) {
        super(parent, modal);
        this.initComponents();
        this._pluginPath = pluginPath;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/TrajStat_Logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(image);
        String cfn = this._pluginPath + File.separator + "working" + File.separator + "CONTROL";
        this._trajConfig.loadControlFile(cfn);
        this._trajConfig.setTrajExcuteFileName(this._pluginPath + File.separator + "working" + File.separator + "hyts_std.exe");
        this.setTrajConfig(this._trajConfig);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel_YearMonth = new JLabel();
        this.jTextField_YearMonth = new JTextField();
        this.jCheckBox_MultiLocations = new JCheckBox();
        this.jLabel_YearMonth1 = new JLabel();
        this.jTextField_StartLocation = new JTextField();
        this.jButton_Locations = new JButton();
        this.jLabel_YearMonth2 = new JLabel();
        this.jTextField_RunHours = new JTextField();
        this.jLabel_YearMonth3 = new JLabel();
        this.jTextField_TopOfModel = new JTextField();
        this.jLabel_YearMonth4 = new JLabel();
        this.jTextField_StartHours = new JTextField();
        this.jPanel_Vertical = new JPanel();
        this.jRadioButton_Isob = new JRadioButton();
        this.jRadioButton_Isen = new JRadioButton();
        this.jRadioButton_Dens = new JRadioButton();
        this.jRadioButton_Data = new JRadioButton();
        this.jRadioButton_Sigma = new JRadioButton();
        this.jButton_Clear = new JButton();
        this.jButton_AddMeteoFiles = new JButton();
        this.jPanel_Duration = new JPanel();
        this.jLabel_YearMonth5 = new JLabel();
        this.jTextField_StartDay = new JTextField();
        this.jLabel_YearMonth6 = new JLabel();
        this.jTextField_EndDay = new JTextField();
        this.jLabel_YearMonth7 = new JLabel();
        this.jTextField_ExcuteFile = new JTextField();
        this.jButton_ExecuteFile = new JButton();
        this.jLabel_YearMonth8 = new JLabel();
        this.jTextField_OutputPath = new JTextField();
        this.jButton_OutPath = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton_LoadConfig = new JButton();
        this.jButton_SaveConfig = new JButton();
        this.jButton_Calculate = new JButton();
        this.jButton_Convert = new JButton();
        this.jButton_Combine = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.jList_MeteoFiles = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Trajectory Monthly Calculation");
        this.setFont(this.getFont().deriveFont(10.0f));
        Font font_12 = this.getFont().deriveFont(12.0f);
        this.jLabel_YearMonth.setFont(font_12);
        this.jLabel_YearMonth.setText("Year_Month (YY MM):");
        this.jTextField_YearMonth.setFont(font_12);
        this.jCheckBox_MultiLocations.setFont(font_12);
        this.jCheckBox_MultiLocations.setText("Multi_Locations");
        this.jCheckBox_MultiLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jCheckBox_MultiLocationsActionPerformed(evt);
            }
        });
        this.jLabel_YearMonth1.setFont(font_12);
        this.jLabel_YearMonth1.setText("Start Location (Lat Lon Height(m agl)):");
        this.jTextField_StartLocation.setFont(font_12);
        this.jTextField_StartLocation.setPreferredSize(new Dimension(6, 24));
        this.jButton_Locations.setFont(font_12);
        this.jButton_Locations.setText("Locations");
        this.jButton_Locations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_LocationsActionPerformed(evt);
            }
        });
        this.jLabel_YearMonth2.setFont(font_12);
        this.jLabel_YearMonth2.setText("Run Hours:");
        this.jTextField_RunHours.setFont(font_12);
        this.jTextField_RunHours.setPreferredSize(new Dimension(6, 24));
        this.jLabel_YearMonth3.setFont(font_12);
        this.jLabel_YearMonth3.setText("Top of Model (m agl):");
        this.jTextField_TopOfModel.setFont(font_12);
        this.jTextField_TopOfModel.setPreferredSize(new Dimension(6, 24));
        this.jLabel_YearMonth4.setFont(font_12);
        this.jLabel_YearMonth4.setText("Starting Hours (HH HH ...):");
        this.jTextField_StartHours.setFont(font_12);
        this.jTextField_StartHours.setPreferredSize(new Dimension(6, 24));
        this.jPanel_Vertical.setBorder(BorderFactory.createTitledBorder(null, "Vertical", 0, 0, new Font("Arial", 0, 12)));
        this.jPanel_Vertical.setFont(font_12);
        this.buttonGroup1.add(this.jRadioButton_Isob);
        this.jRadioButton_Isob.setFont(font_12);
        this.jRadioButton_Isob.setText("1: isob");
        this.buttonGroup1.add(this.jRadioButton_Isen);
        this.jRadioButton_Isen.setFont(font_12);
        this.jRadioButton_Isen.setText("2: isen");
        this.buttonGroup1.add(this.jRadioButton_Dens);
        this.jRadioButton_Dens.setFont(font_12);
        this.jRadioButton_Dens.setText("3: dens");
        this.buttonGroup1.add(this.jRadioButton_Data);
        this.jRadioButton_Data.setFont(font_12);
        this.jRadioButton_Data.setText("0: data");
        this.buttonGroup1.add(this.jRadioButton_Sigma);
        this.jRadioButton_Sigma.setFont(font_12);
        this.jRadioButton_Sigma.setText("4: sigma");
        GroupLayout jPanel_VerticalLayout = new GroupLayout(this.jPanel_Vertical);
        this.jPanel_Vertical.setLayout(jPanel_VerticalLayout);
        jPanel_VerticalLayout.setHorizontalGroup(jPanel_VerticalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_VerticalLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton_Data).addGap(18, 18, 18).addComponent(this.jRadioButton_Isob).addGap(18, 18, 18).addComponent(this.jRadioButton_Isen).addGap(18, 18, 18).addComponent(this.jRadioButton_Dens).addGap(18, 18, 18).addComponent(this.jRadioButton_Sigma).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_VerticalLayout.setVerticalGroup(jPanel_VerticalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_VerticalLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_VerticalLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton_Isob).addComponent(this.jRadioButton_Isen).addComponent(this.jRadioButton_Dens).addComponent(this.jRadioButton_Sigma).addComponent(this.jRadioButton_Data)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Clear.setFont(font_12);
        this.jButton_Clear.setText("Clear");
        this.jButton_Clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_ClearActionPerformed(evt);
            }
        });
        this.jButton_AddMeteoFiles.setFont(font_12);
        this.jButton_AddMeteoFiles.setText("Add Meteorological Files");
        this.jButton_AddMeteoFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_AddMeteoFilesActionPerformed(evt);
            }
        });
        this.jPanel_Duration.setBorder(BorderFactory.createTitledBorder(null, "Duration", 0, 0, new Font("Arial", 0, 12)));
        this.jLabel_YearMonth5.setFont(font_12);
        this.jLabel_YearMonth5.setText("Start Day:");
        this.jTextField_StartDay.setFont(font_12);
        this.jLabel_YearMonth6.setFont(font_12);
        this.jLabel_YearMonth6.setText("End Day:");
        this.jTextField_EndDay.setFont(font_12);
        GroupLayout jPanel_DurationLayout = new GroupLayout(this.jPanel_Duration);
        this.jPanel_Duration.setLayout(jPanel_DurationLayout);
        jPanel_DurationLayout.setHorizontalGroup(jPanel_DurationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DurationLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DurationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_YearMonth5).addComponent(this.jTextField_StartDay, -2, 75, -2).addComponent(this.jLabel_YearMonth6).addComponent(this.jTextField_EndDay, -2, 75, -2)).addContainerGap(18, Short.MAX_VALUE)));
        jPanel_DurationLayout.setVerticalGroup(jPanel_DurationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DurationLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel_YearMonth5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_StartDay, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.jLabel_YearMonth6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_EndDay, -2, -1, -2).addContainerGap()));
        this.jLabel_YearMonth7.setFont(font_12);
        this.jLabel_YearMonth7.setText("Execute File:");
        this.jTextField_ExcuteFile.setFont(font_12);
        this.jTextField_ExcuteFile.setPreferredSize(new Dimension(6, 24));
        this.jButton_ExecuteFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_ExecuteFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_ExecuteFileActionPerformed(evt);
            }
        });
        this.jLabel_YearMonth8.setFont(font_12);
        this.jLabel_YearMonth8.setText("Output Path:");
        this.jTextField_OutputPath.setFont(font_12);
        this.jTextField_OutputPath.setPreferredSize(new Dimension(6, 24));
        this.jButton_OutPath.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_OutPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_OutPathActionPerformed(evt);
            }
        });
        this.jSeparator1.setForeground(new Color(255, 51, 51));
        this.jButton_LoadConfig.setFont(font_12);
        this.jButton_LoadConfig.setText("Load Config");
        this.jButton_LoadConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_LoadConfigActionPerformed(evt);
            }
        });
        this.jButton_SaveConfig.setFont(font_12);
        this.jButton_SaveConfig.setText("Save Config");
        this.jButton_SaveConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_SaveConfigActionPerformed(evt);
            }
        });
        this.jButton_Calculate.setFont(font_12);
        this.jButton_Calculate.setText("Calculate");
        this.jButton_Calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_CalculateActionPerformed(evt);
            }
        });
        this.jButton_Convert.setFont(font_12);
        this.jButton_Convert.setText("Convert");
        this.jButton_Convert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_ConvertActionPerformed(evt);
            }
        });
        this.jButton_Combine.setFont(font_12);
        this.jButton_Combine.setText("Combine");
        this.jButton_Combine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTrajMonth.this.jButton_CombineActionPerformed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList_MeteoFiles);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_YearMonth7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_ExcuteFile, -2, 339, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_ExecuteFile, -2, 40, -2)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel_YearMonth8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_OutputPath, -2, 339, -2).addGap(18, 18, 18).addComponent(this.jButton_OutPath, -2, 40, -2)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel_Vertical, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_YearMonth4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_StartHours, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_YearMonth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_YearMonth, -2, 179, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox_MultiLocations)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_YearMonth1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_StartLocation, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Locations)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_YearMonth2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_RunHours, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_YearMonth3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_TopOfModel, -2, 96, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton_AddMeteoFiles, -2, 193, -2).addGap(18, 18, 18).addComponent(this.jButton_Clear, -2, 74, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2)).addGap(18, 18, 18).addComponent(this.jPanel_Duration, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jButton_LoadConfig).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_SaveConfig).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_Calculate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_Convert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_Combine))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth).addComponent(this.jTextField_YearMonth, -2, -1, -2).addComponent(this.jCheckBox_MultiLocations)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth1).addComponent(this.jTextField_StartLocation, -2, -1, -2).addComponent(this.jButton_Locations)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth2).addComponent(this.jTextField_RunHours, -2, -1, -2).addComponent(this.jLabel_YearMonth3).addComponent(this.jTextField_TopOfModel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth4).addComponent(this.jTextField_StartHours, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel_Vertical, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Clear, -2, 33, -2).addComponent(this.jButton_AddMeteoFiles, -2, 33, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addComponent(this.jPanel_Duration, -2, -1, -2)).addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth7).addComponent(this.jTextField_ExcuteFile, -2, -1, -2)).addComponent(this.jButton_ExecuteFile, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_YearMonth8).addComponent(this.jTextField_OutputPath, -2, -1, -2)).addComponent(this.jButton_OutPath, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_LoadConfig, -2, 33, -2).addComponent(this.jButton_SaveConfig, -2, 33, -2).addComponent(this.jButton_Calculate, -2, 33, -2).addComponent(this.jButton_Convert, -2, 33, -2).addComponent(this.jButton_Combine, -2, 33, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jProgressBar1, -2, 20, -2)));
        this.pack();
    }

    private void jButton_ExecuteFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            this.jTextField_ExcuteFile.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_OutPathActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setFileSelectionMode(1);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            this.jTextField_OutputPath.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_LoadConfigActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            this._trajConfig.loadControlFile(aFile.getAbsolutePath());
        }
    }

    private void jCheckBox_MultiLocationsActionPerformed(ActionEvent evt) {
        if (this.jCheckBox_MultiLocations.isSelected()) {
            this.jTextField_StartLocation.setEnabled(false);
            this.jButton_Locations.setEnabled(true);
        } else {
            this.jTextField_StartLocation.setEnabled(true);
            this.jButton_Locations.setEnabled(false);
        }
    }

    private void jButton_SaveConfigActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            this.getTrajConfig();
            this._trajConfig.saveControlFile(aFile.getAbsolutePath());
        }
    }

    private void jButton_LocationsActionPerformed(ActionEvent evt) {
        FrmStartLocations frm = new FrmStartLocations((Dialog)this, true);
        frm.setLocations(this._trajConfig.getLocations());
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
        if (frm.isOK()) {
            this._trajConfig.setLocations(frm.getLocations());
        }
    }

    private void jButton_AddMeteoFilesActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            DefaultListModel<File> listModel = (DefaultListModel<File>)this.jList_MeteoFiles.getModel();
            if (listModel == null) {
                listModel = new DefaultListModel<File>();
            }
            for (File f : files) {
                listModel.addElement(f.getAbsoluteFile());
            }
            this.jList_MeteoFiles.setModel(listModel);
        }
    }

    private void jButton_ClearActionPerformed(ActionEvent evt) {
        this.jList_MeteoFiles.setModel(new DefaultListModel());
    }

    private void jButton_CalculateActionPerformed(ActionEvent evt) {
        this.getTrajConfig();
        try {
            this.trajCalculation();
        }
        catch (IOException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton_ConvertActionPerformed(ActionEvent evt) {
        this.getTrajConfig();
        try {
            this.convertToTGS();
        }
        catch (IOException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton_CombineActionPerformed(ActionEvent evt) {
        this.getTrajConfig();
        try {
            this.joinTGSFiles();
        }
        catch (IOException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setTrajConfig(TrajConfig tc) {
        this._trajConfig = tc;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yy MM");
        this.jTextField_YearMonth.setText(format.format(tc.getStartTime()));
        if (tc.getLocations().size() > 1) {
            this.jCheckBox_MultiLocations.setSelected(true);
            this.jTextField_StartLocation.setEnabled(false);
            this.jButton_Locations.setEnabled(true);
        } else {
            this.jCheckBox_MultiLocations.setSelected(false);
            this.jTextField_StartLocation.setEnabled(true);
            this.jButton_Locations.setEnabled(false);
            this.jTextField_StartLocation.setText(tc.getLocations().get(0).toString());
        }
        this.jTextField_RunHours.setText(String.valueOf(tc.getRunHours()));
        this.jTextField_TopOfModel.setText(String.valueOf(tc.getTopOfModel()));
        this.jTextField_StartHours.setText(tc.getStartHoursString());
        switch (tc.getVertical()) {
            case 0: {
                this.jRadioButton_Data.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButton_Isob.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButton_Isen.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButton_Dens.setSelected(true);
                break;
            }
            case 4: {
                this.jRadioButton_Sigma.setSelected(true);
            }
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String mfn : tc.getMeteoFiles()) {
            listModel.addElement(mfn);
        }
        this.jList_MeteoFiles.setModel(listModel);
        this.jTextField_StartDay.setText(String.valueOf(tc.getStartDay()));
        this.jTextField_EndDay.setText(String.valueOf(tc.getEndDay()));
        this.jTextField_ExcuteFile.setText(tc.getTrajExcuteFileName());
        this.jTextField_OutputPath.setText(tc.getOutPath());
    }

    private void getTrajConfig() {
        this._trajConfig.setStartHours(this.jTextField_StartHours.getText());
        this._trajConfig.setStartDay(Integer.parseInt(this.jTextField_StartDay.getText()));
        this._trajConfig.setEndDay(Integer.parseInt(this.jTextField_EndDay.getText()));
        String ymStr = this.jTextField_YearMonth.getText();
        String[] strs = ymStr.trim().split("\\s+");
        int year = Integer.parseInt(strs[0]);
        int month = Integer.parseInt(strs[1]);
        year = year < 50 ? 2000 + year : 1900 + year;
        this._trajConfig.initStartTime(year, month);
        if (!this.jCheckBox_MultiLocations.isSelected()) {
            ArrayList<Location> locations = new ArrayList<Location>();
            locations.add(new Location(this.jTextField_StartLocation.getText().trim()));
            this._trajConfig.setLocations(locations);
        }
        this._trajConfig.setRunHours(Integer.parseInt(this.jTextField_RunHours.getText()));
        this._trajConfig.setTopOfModel(Float.parseFloat(this.jTextField_TopOfModel.getText()));
        int v = 0;
        if (this.jRadioButton_Data.isSelected()) {
            v = 0;
        } else if (this.jRadioButton_Isob.isSelected()) {
            v = 1;
        } else if (this.jRadioButton_Isen.isSelected()) {
            v = 2;
        } else if (this.jRadioButton_Dens.isSelected()) {
            v = 3;
        } else if (this.jRadioButton_Sigma.isSelected()) {
            v = 4;
        }
        this._trajConfig.setVertical(v);
        DefaultListModel listModel = (DefaultListModel)this.jList_MeteoFiles.getModel();
        ArrayList<String> meteoFiles = new ArrayList<String>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            meteoFiles.add(listModel.get(i).toString());
        }
        this._trajConfig.setMeteoFiles(meteoFiles);
        this._trajConfig.setTrajExcuteFileName(this.jTextField_ExcuteFile.getText());
        this._trajConfig.setOutPath(this.jTextField_OutputPath.getText());
    }

    private void trajCalculation() throws IOException, InterruptedException {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                FrmTrajMonth.this.setCursor(Cursor.getPredefinedCursor(3));
                String cfn = FrmTrajMonth.this._pluginPath + File.separator + "working" + File.separator + "CONTROL";
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                int dayNum = FrmTrajMonth.this._trajConfig.getDayNum();
                int hourNum = FrmTrajMonth.this._trajConfig.getStartHoursNum();
                int tnum = dayNum * hourNum;
                for (int i = 0; i < dayNum; ++i) {
                    for (int j = 0; j < hourNum; ++j) {
                        String s;
                        FrmTrajMonth.this._trajConfig.upateStartTime(i, j);
                        FrmTrajMonth.this._trajConfig.saveControlFile(cfn);
                        ProcessBuilder pb = new ProcessBuilder(FrmTrajMonth.this._trajConfig.getTrajExcuteFileName());
                        pb.directory(new File(FrmTrajMonth.this._pluginPath + File.separator + "working"));
                        Process process = pb.start();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while ((s = bufferedReader.readLine()) != null) {
                            System.out.println(s);
                        }
                        process.waitFor();
                        FrmTrajMonth.this.jProgressBar1.setValue((int)((double)(i * hourNum + j + 1) / (double)tnum * 100.0));
                    }
                }
                return "";
            }

            @Override
            protected void done() {
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                FrmTrajMonth.this.setCursor(null);
            }
        };
        worker.execute();
    }

    private void convertToTGS() throws IOException, InterruptedException {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                FrmTrajMonth.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                int dayNum = FrmTrajMonth.this._trajConfig.getDayNum();
                int hourNum = FrmTrajMonth.this._trajConfig.getStartHoursNum();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
                for (int i = 0; i < dayNum; ++i) {
                    FrmTrajMonth.this._trajConfig.upateStartTime(i, 0);
                    String tgsfn = FrmTrajMonth.this._trajConfig.getOutPath() + format.format(FrmTrajMonth.this._trajConfig.getStartTime()) + ".tgs";
                    ArrayList<String> trajfns = new ArrayList<String>();
                    for (int j = 0; j < hourNum; ++j) {
                        FrmTrajMonth.this._trajConfig.upateStartTime(i, j);
                        String trajfn = FrmTrajMonth.this._trajConfig.getOutPath() + FrmTrajMonth.this._trajConfig.getTrajFileName();
                        trajfns.add(trajfn);
                    }
                    TrajUtil.trajToTGS(trajfns, tgsfn);
                    FrmTrajMonth.this.jProgressBar1.setValue((int)((double)(i + 1) / (double)dayNum * 100.0));
                }
                return "";
            }

            @Override
            protected void done() {
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                FrmTrajMonth.this.setCursor(null);
            }
        };
        worker.execute();
    }

    private void joinTGSFiles() throws IOException, InterruptedException {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                FrmTrajMonth.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                int dayNum = FrmTrajMonth.this._trajConfig.getDayNum();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMM");
                String monthfn = FrmTrajMonth.this._trajConfig.getOutPath() + format.format(FrmTrajMonth.this._trajConfig.getStartTime()) + ".tgs";
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(monthfn)));
                bw.write("start_year,start_month,start_day,start_hour,year,month,day,hour,age_hour,latitude,longitude,height,press");
                bw.newLine();
                format = DateTimeFormatter.ofPattern("yyyyMMdd");
                for (int i = 0; i < dayNum; ++i) {
                    FrmTrajMonth.this._trajConfig.upateStartTime(i, 0);
                    String tgsfn = FrmTrajMonth.this._trajConfig.getOutPath() + format.format(FrmTrajMonth.this._trajConfig.getStartTime()) + ".tgs";
                    if (!new File(tgsfn).exists()) continue;
                    BufferedReader sr = new BufferedReader(new FileReader(new File(tgsfn)));
                    sr.readLine();
                    String aLine = sr.readLine();
                    while (aLine != null) {
                        if (aLine.isEmpty()) {
                            aLine = sr.readLine();
                        }
                        bw.write(aLine);
                        bw.newLine();
                        aLine = sr.readLine();
                    }
                    sr.close();
                    FrmTrajMonth.this.jProgressBar1.setValue((int)((double)(i + 1) / (double)dayNum * 100.0));
                }
                bw.close();
                return "";
            }

            @Override
            protected void done() {
                FrmTrajMonth.this.jProgressBar1.setValue(0);
                FrmTrajMonth.this.setCursor(null);
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmTrajMonth.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmTrajMonth dialog = new FrmTrajMonth((Frame)new JFrame(), true, "");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

