/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.geo.analysis.Clustering;
import org.meteoinfo.geo.analysis.DistanceType;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.ui.JCheckBoxList;
import org.meteothink.trajstat.Main;
import org.meteothink.trajstat.trajectory.TrajUtil;

public class FrmClusterCal
extends JDialog {
    private final IApplication app;
    private JCheckBoxList checkBoxList_Data;
    private JButton jButton1;
    private JButton jButton_AddToTraj;
    private JButton jButton_Calculate;
    private JButton jButton_MeanTraj;
    private JButton jButton_OutputFile;
    private JButton jButton_SelAll;
    private JButton jButton_viewTSV;
    private JCheckBox jCheckBox_3D;
    private JCheckBox jCheckBox_IgnoreDataLines;
    private JComboBox jComboBox_ClusterNum;
    private JComboBox jComboBox_Distance;
    private JComboBox jComboBox_MaxClusterNum;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel_PointNum;
    private JLabel jLabel_PointNumValue;
    private JLabel jLabel_TrajNum;
    private JLabel jLabel_TrajNumValue;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_OutputFile;
    private JTextField jTextField_PointInterval;

    public FrmClusterCal(Frame parent, boolean modal) {
        super(parent, modal);
        int i;
        this.initComponents();
        this.app = (IApplication)parent;
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        DefaultListModel<CheckBoxListEntry> listModel = new DefaultListModel<CheckBoxListEntry>();
        for (i = 0; i < gNode.getLayers().size(); ++i) {
            LayerNode lNode = (LayerNode)gNode.getLayers().get(i);
            CheckBoxListEntry cbe = i == gNode.getLayers().size() - 1 ? new CheckBoxListEntry((Object)lNode.getMapLayer(), true) : new CheckBoxListEntry((Object)lNode.getMapLayer(), false);
            listModel.insertElementAt(cbe, 0);
        }
        this.checkBoxList_Data.setModel(listModel);
        this.checkBoxList_Data.setSelectedIndex(0);
        this.jComboBox_Distance.removeAllItems();
        this.jComboBox_Distance.addItem(DistanceType.EUCLIDEAN);
        this.jComboBox_Distance.addItem(DistanceType.ANGLE);
        this.jComboBox_MaxClusterNum.removeAllItems();
        for (i = 9; i <= 30; ++i) {
            this.jComboBox_MaxClusterNum.addItem(i);
        }
        this.jComboBox_MaxClusterNum.setSelectedItem(30);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBox_IgnoreDataLines = new JCheckBox();
        this.jLabel_TrajNum = new JLabel();
        this.jLabel_PointNum = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextField_OutputFile = new JTextField();
        this.jButton_OutputFile = new JButton();
        this.jLabel5 = new JLabel();
        this.jComboBox_Distance = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBox_MaxClusterNum = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.checkBoxList_Data = new JCheckBoxList();
        this.jButton_SelAll = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextField_PointInterval = new JTextField();
        this.jLabel_TrajNumValue = new JLabel();
        this.jLabel_PointNumValue = new JLabel();
        this.jButton1 = new JButton();
        this.jCheckBox_3D = new JCheckBox();
        this.jButton_Calculate = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jComboBox_ClusterNum = new JComboBox();
        this.jButton_MeanTraj = new JButton();
        this.jButton_AddToTraj = new JButton();
        this.jButton_viewTSV = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Cluster calculation");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Setting"));
        this.jCheckBox_IgnoreDataLines.setText("Ignore the data lines with abnormal point number");
        this.jLabel_TrajNum.setText("Traj number:");
        this.jLabel_PointNum.setText("Point number:");
        this.jLabel4.setText("Output file:");
        this.jButton_OutputFile.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Open.Image.png")));
        this.jButton_OutputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_OutputFileActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Distance:");
        this.jComboBox_Distance.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText("Max cluster number:");
        this.jComboBox_MaxClusterNum.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_MaxClusterNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jComboBox_MaxClusterNumActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Trajectory layers:");
        this.checkBoxList_Data.setModel((ListModel)new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.checkBoxList_Data.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmClusterCal.this.checkBoxList_DataValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.checkBoxList_Data);
        this.jButton_SelAll.setText("Select All");
        this.jButton_SelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_SelAllActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Point interval:");
        this.jTextField_PointInterval.setText("1");
        this.jLabel_TrajNumValue.setText("...");
        this.jLabel_PointNumValue.setText("...");
        this.jButton1.setText("<html>Check point<br />number</html>");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton1ActionPerformed(evt);
            }
        });
        this.jCheckBox_3D.setText("3D");
        this.jCheckBox_3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jCheckBox_3DActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_IgnoreDataLines).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -2, 380, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_SelAll, -2, 128, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel_TrajNum).addComponent(this.jLabel_PointNum).addComponent(this.jLabel_TrajNumValue).addComponent(this.jLabel_PointNumValue).addComponent(this.jTextField_PointInterval, -2, 46, -2))).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_Distance, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_3D, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_MaxClusterNum, -2, 87, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_OutputFile).addGap(18, 18, 18).addComponent(this.jButton_OutputFile, -2, 40, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton_SelAll)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -2, 224, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(3, 3, 3).addComponent(this.jTextField_PointInterval, -2, -1, -2).addGap(30, 30, 30).addComponent(this.jLabel_TrajNum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_TrajNumValue).addGap(18, 18, 18).addComponent(this.jLabel_PointNum).addGap(3, 3, 3).addComponent(this.jLabel_PointNumValue).addGap(18, 18, 18).addComponent(this.jButton1))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_IgnoreDataLines).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_OutputFile, -2, 25, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField_OutputFile, -2, -1, -2))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBox_Distance, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jComboBox_MaxClusterNum, -2, -1, -2).addComponent(this.jCheckBox_3D)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Calculate.setText("Calculate");
        this.jButton_Calculate.setHorizontalTextPosition(0);
        this.jButton_Calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_CalculateActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel7.setText("Cluster number:");
        this.jComboBox_ClusterNum.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton_MeanTraj.setText("Mean Traj");
        this.jButton_MeanTraj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_MeanTrajActionPerformed(evt);
            }
        });
        this.jButton_AddToTraj.setText("Add to traj");
        this.jButton_AddToTraj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_AddToTrajActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox_ClusterNum, -2, 90, -2)).addGap(24, 24, 24).addComponent(this.jButton_MeanTraj).addGap(18, 18, 18).addComponent(this.jButton_AddToTraj).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_AddToTraj, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_MeanTraj, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_ClusterNum, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jButton_viewTSV.setText("View TSV");
        this.jButton_viewTSV.setHorizontalTextPosition(0);
        this.jButton_viewTSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmClusterCal.this.jButton_viewTSVActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Calculate, -2, 108, -2).addComponent(this.jButton_viewTSV, -2, 108, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(26, 26, 26)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jButton_Calculate, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_viewTSV, -2, 32, -2))).addGap(12, 12, 12)));
        this.pack();
    }

    private void jButton_OutputFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_OutputFile.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_SelAllActionPerformed(ActionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
        if (this.jButton_SelAll.getText().equals("Select All")) {
            for (int i = 0; i < listModel.getSize(); ++i) {
                ((CheckBoxListEntry)listModel.get(i)).setSelected(true);
            }
            this.jButton_SelAll.setText("Unselect All");
        } else {
            for (int i = 0; i < listModel.getSize(); ++i) {
                ((CheckBoxListEntry)listModel.get(i)).setSelected(false);
            }
            this.jButton_SelAll.setText("Select All");
        }
        this.checkBoxList_Data.repaint();
    }

    private void jComboBox_MaxClusterNumActionPerformed(ActionEvent evt) {
        if (this.jComboBox_MaxClusterNum.getItemCount() > 0) {
            int cnum = (Integer)this.jComboBox_MaxClusterNum.getSelectedItem();
            this.jComboBox_ClusterNum.removeAllItems();
            for (int i = 2; i <= cnum; ++i) {
                this.jComboBox_ClusterNum.addItem(i);
            }
            this.jComboBox_ClusterNum.setSelectedIndex(4);
        }
    }

    private void checkBoxList_DataValueChanged(ListSelectionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
        int trajNum = 0;
        int pointNum = 0;
        int n = 0;
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
            VectorLayer layer = (VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue();
            if (n == 0) {
                PolylineZShape shape = (PolylineZShape)layer.getShapes().get(0);
                pointNum = shape.getPointNum();
            }
            trajNum += layer.getShapeNum();
            ++n;
        }
        this.jLabel_PointNumValue.setText(String.valueOf(pointNum));
        this.jLabel_TrajNumValue.setText(String.valueOf(trajNum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_CalculateActionPerformed(ActionEvent evt) {
        int trajNum;
        if (this.checkBoxList_Data.getCheckedItems().isEmpty()) {
            JOptionPane.showMessageDialog(this, "There is no trajectory layer was selected!");
            return;
        }
        String outfn = this.jTextField_OutputFile.getText();
        if (outfn.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Output file should be set!");
            return;
        }
        int maxClusterNum = (Integer)this.jComboBox_MaxClusterNum.getSelectedItem();
        if (maxClusterNum >= (trajNum = Integer.parseInt(this.jLabel_TrajNumValue.getText()))) {
            maxClusterNum = trajNum - 1;
            StringBuilder sb = new StringBuilder();
            sb.append("Trajectory number less then maximum cluster number!");
            sb.append("\n");
            sb.append(String.format("The maximum cluster number will be set as: %d", maxClusterNum));
            JOptionPane.showMessageDialog(this, sb.toString());
            this.jComboBox_MaxClusterNum.setSelectedItem(maxClusterNum);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
        ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
            layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
        }
        DistanceType disType = (DistanceType)this.jComboBox_Distance.getSelectedItem();
        int pointNum = Integer.parseInt(this.jLabel_PointNumValue.getText());
        int interval = Integer.parseInt(this.jTextField_PointInterval.getText());
        int npointNum = pointNum / interval;
        if (pointNum % interval > 0) {
            ++npointNum;
        }
        boolean is3D = this.jCheckBox_3D.isSelected();
        try {
            if (is3D) {
                Clustering.calculate3D(layers, (String)outfn, (int)trajNum, (int)npointNum, (int)maxClusterNum, (int)interval);
            } else {
                Clustering.calculate(layers, (String)outfn, (int)trajNum, (int)npointNum, (int)maxClusterNum, (int)interval, (DistanceType)disType);
            }
            JOptionPane.showMessageDialog(null, "Clustering calculation finished!");
        }
        catch (IOException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_MeanTrajActionPerformed(ActionEvent evt) {
        block37: {
            BufferedReader src = null;
            try {
                int j;
                int pointNum;
                int i;
                String clusterFile = this.jTextField_OutputFile.getText();
                if (!new File(clusterFile).exists()) {
                    JOptionPane.showMessageDialog(null, "File does not exist!" + System.getProperty("line.separator") + clusterFile);
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                for (i = 0; i < listModel.getSize(); ++i) {
                    if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                    layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
                }
                int CLev = 0;
                CLev = (Integer)this.jComboBox_ClusterNum.getSelectedItem();
                int M = pointNum = Integer.parseInt(this.jLabel_PointNumValue.getText());
                double[][][] trajDataArray = new double[CLev][M][4];
                int[] trajNumArray = new int[CLev];
                src = new BufferedReader(new FileReader(new File(clusterFile)));
                src.readLine();
                i = 0;
                int totalTrajNum = 0;
                for (VectorLayer layer : layers) {
                    for (int s = 0; s < layer.getShapeNum(); ++s) {
                        PolylineZShape shape = (PolylineZShape)layer.getShapes().get(s);
                        if (shape.getPointNum() != pointNum) continue;
                        String aLine = src.readLine();
                        int Cluster = Integer.parseInt(aLine.split(",")[CLev]);
                        for (j = 0; j < pointNum; ++j) {
                            PointZ point = (PointZ)shape.getPoints().get(j);
                            double[] dArray = trajDataArray[Cluster - 1][j];
                            dArray[0] = dArray[0] + point.Y;
                            double[] dArray2 = trajDataArray[Cluster - 1][j];
                            dArray2[1] = dArray2[1] + point.X;
                            double[] dArray3 = trajDataArray[Cluster - 1][j];
                            dArray3[2] = dArray3[2] + point.Z;
                            double[] dArray4 = trajDataArray[Cluster - 1][j];
                            dArray4[3] = dArray4[3] + point.M;
                        }
                        int n = Cluster - 1;
                        trajNumArray[n] = trajNumArray[n] + 1;
                        ++totalTrajNum;
                        ++i;
                    }
                }
                for (i = 0; i < CLev; ++i) {
                    for (j = 0; j < M; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            trajDataArray[i][j][k] = trajDataArray[i][j][k] / (double)trajNumArray[i];
                        }
                    }
                }
                String userPath = System.getProperty("user.dir");
                File pathDir = new File(userPath);
                JFileChooser aDlg = new JFileChooser();
                String[] fileExts = new String[]{"shp"};
                GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
                aDlg.setFileFilter((FileFilter)pFileFilter);
                aDlg.setAcceptAllFileFilterUsed(false);
                aDlg.setCurrentDirectory(pathDir);
                if (0 != aDlg.showSaveDialog((JFrame)this.app)) break block37;
                File file = aDlg.getSelectedFile();
                String shpfn = "";
                try {
                    shpfn = file.getCanonicalPath();
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                if (!shpfn.substring(shpfn.length() - extent.length()).equals(extent)) {
                    shpfn = shpfn + "." + extent;
                }
                VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
                aLayer.editAddField("Cluster", DataType.STRING);
                aLayer.editAddField("Traj_Num", DataType.INT);
                aLayer.editAddField("Ratio", DataType.STRING);
                for (i = 0; i < CLev; ++i) {
                    try {
                        PolylineZShape aPLZ = new PolylineZShape();
                        ArrayList<PointZ> points = new ArrayList<PointZ>();
                        for (j = 0; j < pointNum; ++j) {
                            PointZ pt = new PointZ();
                            pt.Y = trajDataArray[i][j][0];
                            pt.X = trajDataArray[i][j][1];
                            pt.Z = trajDataArray[i][j][2];
                            pt.M = trajDataArray[i][j][3];
                            points.add(pt);
                        }
                        aPLZ.setPoints(points);
                        int shapeNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape((Shape)aPLZ, shapeNum)) continue;
                        aLayer.editCellValue("Cluster", shapeNum, (Object)String.valueOf(shapeNum + 1));
                        aLayer.editCellValue("Traj_Num", shapeNum, (Object)trajNumArray[i]);
                        String aRatio = String.format("%1$.2f", (double)trajNumArray[i] / (double)totalTrajNum * 100.0) + "%";
                        aLayer.editCellValue("Ratio", shapeNum, (Object)aRatio);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (aLayer.getShapeNum() <= 0) {
                    JOptionPane.showMessageDialog(null, "No valid shapes created.");
                    return;
                }
                aLayer.setLayerName(file.getName());
                LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.black, (float)1.0f);
                aLS.setFieldName("Cluster");
                aLayer.setLegendScheme(aLS);
                aLayer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
                aLayer.setFileName(shpfn);
                aLayer.saveFile(shpfn);
                Main.addLayer(aLayer, this.app.getMapDocument().getActiveMapFrame(), "Cluster");
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
                try {
                    src.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_AddToTrajActionPerformed(ActionEvent evt) {
        BufferedReader src = null;
        try {
            String clusterFile = this.jTextField_OutputFile.getText();
            if (!new File(clusterFile).exists()) {
                JOptionPane.showMessageDialog(null, "File does not exist!" + System.getProperty("line.separator") + clusterFile);
                return;
            }
            int CLev = (Integer)this.jComboBox_ClusterNum.getSelectedItem();
            ArrayList<String[]> cDataArray = new ArrayList<String[]>();
            src = new BufferedReader(new FileReader(new File(clusterFile)));
            src.readLine();
            String aLine = src.readLine();
            while (aLine != null) {
                if (aLine.isEmpty()) continue;
                String[] aDataArray = aLine.split(",");
                String[] data = new String[]{aDataArray[0], aDataArray[1], aDataArray[CLev]};
                cDataArray.add(data);
                aLine = src.readLine();
            }
            src.close();
            DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
            ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
            }
            this.addClusterToLayers(cDataArray, layers);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                src.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_viewTSVActionPerformed(ActionEvent evt) {
        BufferedReader src = null;
        try {
            int i;
            String clusterFile = this.jTextField_OutputFile.getText();
            if (!new File(clusterFile).exists()) {
                JOptionPane.showMessageDialog(null, "File does not exist!" + System.getProperty("line.separator") + clusterFile);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
            ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
            for (i = 0; i < listModel.getSize(); ++i) {
                if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
            }
            int maxClusterNum = (Integer)this.jComboBox_MaxClusterNum.getSelectedItem();
            DistanceType disType = (DistanceType)this.jComboBox_Distance.getSelectedItem();
            ArrayList clusters = new ArrayList();
            for (i = 2; i <= maxClusterNum; ++i) {
                clusters.add(new ArrayList());
            }
            int pointNum = Integer.parseInt(this.jLabel_PointNumValue.getText());
            src = new BufferedReader(new FileReader(clusterFile));
            src.readLine();
            String line = src.readLine();
            while (line != null) {
                String[] dArray = line.split(",");
                if (dArray.length >= maxClusterNum) {
                    for (i = 2; i <= maxClusterNum; ++i) {
                        int cluster = Integer.parseInt(dArray[i]);
                        ((List)clusters.get(i - 2)).add(cluster);
                    }
                }
                line = src.readLine();
            }
            src.close();
            ArrayList<Double> tsvrs = new ArrayList<Double>();
            double tsv1 = 0.0;
            for (i = 2; i <= maxClusterNum; ++i) {
                List cls = (List)clusters.get(i - 2);
                double tsv2 = TrajUtil.calTSV(cls, i, pointNum, layers, disType);
                if (i == 2) {
                    tsv1 = tsv2;
                    continue;
                }
                double r = Math.abs(tsv2 - tsv1) * 100.0 / tsv1;
                tsvrs.add(r);
                tsv1 = tsv2;
            }
            XYListDataset dataset = new XYListDataset();
            int n = maxClusterNum - 2;
            double[] xvs = new double[n];
            double[] yvs = new double[n];
            ArrayList<Double> xTickValues = new ArrayList<Double>();
            xTickValues.add(0.0);
            xTickValues.add(1.0);
            for (i = 0; i < n; ++i) {
                xvs[i] = i + 2;
                xTickValues.add(Double.valueOf(i + 2));
                yvs[i] = (Double)tsvrs.get(i);
            }
            xTickValues.add(Double.valueOf(n + 2));
            dataset.addSeries("S_1", xvs, yvs);
            XY1DPlot plot = new XY1DPlot((XYDataset)dataset);
            ((PolylineBreak)plot.getLegendBreak(0)).setDrawSymbol(true);
            plot.getGridLine().setDrawXLine(true);
            plot.getGridLine().setDrawYLine(true);
            plot.getXAxis().setInverse(true);
            plot.getXAxis().setLabel("Number of clusters");
            plot.getXAxis().setDrawLabel(true);
            plot.getXAxis().setTickValues(xTickValues);
            plot.getYAxis().setLabel("Percent change in TVS (%)");
            plot.getYAxis().setDrawLabel(true);
            Chart chart = new Chart((Plot)plot);
            ChartPanel chartPanel = new ChartPanel(chart);
            JFrame frame = new JFrame();
            BufferedImage image = null;
            try {
                image = ImageIO.read(this.getClass().getResource("/images/TrajStat_Logo.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            frame.setIconImage(image);
            frame.getContentPane().add((Component)chartPanel, "Center");
            frame.setSize(600, 400);
            frame.setDefaultCloseOperation(2);
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
        }
        catch (IOException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            try {
                if (src != null) {
                    src.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
        ArrayList<LocalDateTime> tDates = new ArrayList<LocalDateTime>();
        ArrayList<Integer> pNumsAll = new ArrayList<Integer>();
        ArrayList<Integer> pNums = new ArrayList<Integer>();
        ArrayList<Integer> pNumNums = new ArrayList<Integer>();
        int pointNum = 0;
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
            VectorLayer layer = (VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue();
            for (int j = 0; j < layer.getShapeNum(); ++j) {
                PolylineZShape shape = (PolylineZShape)layer.getShapes().get(j);
                LocalDateTime date = (LocalDateTime)layer.getCellValue("Date", j);
                int hour = Integer.parseInt(layer.getCellValue("Hour", j).toString());
                date = date.withHour(hour);
                tDates.add(date);
                pointNum = shape.getPointNum();
                pNumsAll.add(pointNum);
                int idx = pNums.indexOf(pointNum);
                if (idx >= 0) {
                    pNumNums.set(idx, (Integer)pNumNums.get(idx) + 1);
                    continue;
                }
                pNums.add(pointNum);
                pNumNums.add(1);
            }
        }
        if (pNums.size() == 1) {
            JOptionPane.showMessageDialog(this, String.format("All trajectories have same point number: %d", pNums.get(0)));
        } else {
            int nn = 0;
            int num = 0;
            for (int i = 0; i < pNums.size(); ++i) {
                if (nn >= (Integer)pNumNums.get(i)) continue;
                nn = (Integer)pNumNums.get(i);
                num = (Integer)pNums.get(i);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Not all trajectories have same point number!");
            sb.append("\n");
            sb.append(String.format("Most frequent point number: %d", num));
            sb.append("\n");
            sb.append("Trajectories may not calculated correctly:");
            DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < tDates.size(); ++i) {
                if ((Integer)pNumsAll.get(i) == num) continue;
                sb.append("\n");
                sb.append(String.format("%s: %d", sdf.format((TemporalAccessor)tDates.get(i)), pNumsAll.get(i)));
            }
            JOptionPane.showMessageDialog(this, sb.toString());
        }
    }

    private void jCheckBox_3DActionPerformed(ActionEvent evt) {
        if (this.jCheckBox_3D.isSelected()) {
            this.jComboBox_Distance.setEnabled(false);
            this.jComboBox_Distance.setSelectedItem(DistanceType.EUCLIDEAN);
        } else {
            this.jComboBox_Distance.setEnabled(true);
        }
    }

    private void addClusterToLayers(final List<String[]> cDataArray, final List<VectorLayer> layers) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                FrmClusterCal.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmClusterCal.this.app.getProgressBar().setVisible(true);
                FrmClusterCal.this.app.getProgressBar().setValue(0);
                FrmClusterCal.this.app.getProgressBarLabel().setVisible(true);
                FrmClusterCal.this.app.getProgressBarLabel().setText("...");
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
                for (VectorLayer layer : layers) {
                    FrmClusterCal.this.app.getProgressBarLabel().setText(layer.getLayerName());
                    if (layer.getFieldIdxByName("Cluster") == -1) {
                        layer.editAddField("Cluster", DataType.STRING);
                    }
                    int sNum = layer.getShapeNum();
                    for (int i = 0; i < sNum; ++i) {
                        LocalDateTime aDate = (LocalDateTime)layer.getCellValue("Date", i);
                        int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                        aDate = aDate.withHour(hour);
                        String aDateStr = format.format(aDate);
                        String height = layer.getCellValue("Height", i).toString();
                        for (int j = 0; j < cDataArray.size(); ++j) {
                            if (!aDateStr.equals(((String[])cDataArray.get(j))[0]) || !height.equals(((String[])cDataArray.get(j))[1])) continue;
                            layer.editCellValue("Cluster", i, (Object)((String[])cDataArray.get(j))[2]);
                            break;
                        }
                        FrmClusterCal.this.app.getProgressBar().setValue((int)((float)(i + 1) / (float)sNum * 100.0f));
                    }
                    layer.getAttributeTable().save();
                }
                return "";
            }

            @Override
            protected void done() {
                FrmClusterCal.this.app.getProgressBar().setVisible(false);
                FrmClusterCal.this.app.getProgressBarLabel().setVisible(false);
                FrmClusterCal.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmClusterCal dialog = new FrmClusterCal((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

