/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.distribution;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.meteoinfo.math.MathEx;
import org.meteoinfo.math.stats.distribution.AbstractDistribution;
import org.meteoinfo.math.stats.distribution.Distribution;

public class Mixture
extends AbstractDistribution {
    private static final long serialVersionUID = 2L;
    public final Component[] components;

    public Mixture(Component ... components) {
        if (components.length == 0) {
            throw new IllegalStateException("Empty mixture!");
        }
        double sum = 0.0;
        for (Component component : components) {
            sum += component.priori;
        }
        if (Math.abs(sum - 1.0) > 0.001) {
            throw new IllegalArgumentException("The sum of priori is not equal to 1.");
        }
        this.components = components;
    }

    public double[] posteriori(double x) {
        int k = this.components.length;
        double[] prob = new double[k];
        for (int i = 0; i < k; ++i) {
            Component c = this.components[i];
            prob[i] = c.priori * c.distribution.p(x);
        }
        double p = MathEx.sum(prob);
        int i = 0;
        while (i < k) {
            int n = i++;
            prob[n] = prob[n] / p;
        }
        return prob;
    }

    public int map(double x) {
        int k = this.components.length;
        double[] prob = new double[k];
        for (int i = 0; i < k; ++i) {
            Component c = this.components[i];
            prob[i] = c.priori * c.distribution.p(x);
        }
        return MathEx.whichMax(prob);
    }

    @Override
    public double mean() {
        double mu = 0.0;
        for (Component c : this.components) {
            mu += c.priori * c.distribution.mean();
        }
        return mu;
    }

    @Override
    public double variance() {
        double variance = 0.0;
        for (Component c : this.components) {
            variance += c.priori * c.priori * c.distribution.variance();
        }
        return variance;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Mixture does not support entropy()");
    }

    @Override
    public double p(double x) {
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.p(x);
        }
        return p;
    }

    @Override
    public double logp(double x) {
        return Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.cdf(x);
        }
        return p;
    }

    @Override
    public double rand() {
        double r = MathEx.random();
        double p = 0.0;
        for (Component g : this.components) {
            if (!(r <= (p += g.priori))) continue;
            return g.distribution.rand();
        }
        throw new IllegalStateException();
    }

    @Override
    public double quantile(double p) {
        double xu;
        double xl;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        double inc = 1.0;
        double x = (int)this.mean();
        if (p < this.cdf(x)) {
            while (p < this.cdf(x -= (inc *= 2.0))) {
            }
            xl = x;
            xu = x + inc / 2.0;
        } else {
            while (p > this.cdf(x += (inc *= 2.0))) {
            }
            xu = x;
            xl = x - inc / 2.0;
        }
        return this.quantile(p, xl, xu);
    }

    @Override
    public int length() {
        int length = this.components.length - 1;
        for (Component component : this.components) {
            length += component.distribution.length();
        }
        return length;
    }

    public int size() {
        return this.components.length;
    }

    public double bic(double[] data) {
        int n = data.length;
        double logLikelihood = 0.0;
        for (double x : data) {
            double p = this.p(x);
            if (!(p > 0.0)) continue;
            logLikelihood += Math.log(p);
        }
        return logLikelihood - 0.5 * (double)this.length() * Math.log(n);
    }

    public String toString() {
        return Arrays.stream(this.components).map(component -> String.format("%.2f x %s", component.priori, component.distribution)).collect(Collectors.joining(" + ", String.format("Mixture(%d)[", this.components.length), "]"));
    }

    public static class Component
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final double priori;
        public final Distribution distribution;

        public Component(double priori, Distribution distribution) {
            this.priori = priori;
            this.distribution = distribution;
        }
    }
}

