/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.special;

import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.gamma.Erf;
import org.apache.commons.numbers.gamma.Gamma;
import org.apache.commons.numbers.gamma.LogGamma;
import org.meteoinfo.math.special.Airy;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class SpecialUtil {
    public static long factorial(int n) {
        return n >= 0 ? Factorial.value((int)n) : 0L;
    }

    public static Array factorial(Array x) {
        Array r = Array.factory((DataType)DataType.LONG, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator rIter = r.getIndexIterator();
        while (xIter.hasNext()) {
            rIter.setLongNext(SpecialUtil.factorial(xIter.getIntNext()));
        }
        return r;
    }

    public static double gamma(double x) {
        return Gamma.value((double)x);
    }

    public static Array gamma(Array x) {
        x = x.copyIfView();
        Array y = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            yIter.setDoubleNext(Gamma.value((double)xIter.getDoubleNext()));
        }
        return y;
    }

    public static double logGamma(double x) {
        return LogGamma.value((double)x);
    }

    public static Array logGamma(Array x) {
        x = x.copyIfView();
        Array y = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        while (xIter.hasNext()) {
            yIter.setDoubleNext(LogGamma.value((double)xIter.getDoubleNext()));
        }
        return y;
    }

    public static double erf(double x) {
        return Erf.value((double)x);
    }

    public static Array erf(Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator rIter = r.getIndexIterator();
        while (xIter.hasNext()) {
            rIter.setDoubleNext(Erf.value((double)xIter.getDoubleNext()));
        }
        return r;
    }

    public static double erfc(double x) {
        return Erf.value((double)x);
    }

    public static Array erfc(Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator rIter = r.getIndexIterator();
        while (xIter.hasNext()) {
            rIter.setDoubleNext(Erf.value((double)xIter.getDoubleNext()));
        }
        return r;
    }

    public static double[] airy(double x) {
        return new double[]{Airy.airy(x), Airy.airyDerivative(x)};
    }

    public static Array[] airy(Array x) {
        Array ai = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        Array aip = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator aiIter = ai.getIndexIterator();
        IndexIterator aipIter = aip.getIndexIterator();
        while (xIter.hasNext()) {
            double v = xIter.getDoubleNext();
            aiIter.setDoubleNext(Airy.airy(v));
            aipIter.setDoubleNext(Airy.airyDerivative(v));
        }
        return new Array[]{ai, aip};
    }
}

