/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.spatial.distance;

import org.meteoinfo.math.distance.ChebyshevDistance;
import org.meteoinfo.math.distance.CorrelationDistance;
import org.meteoinfo.math.distance.Distance;
import org.meteoinfo.math.distance.EuclideanDistance;
import org.meteoinfo.math.distance.HammingDistance;
import org.meteoinfo.math.distance.JaccardDistance;
import org.meteoinfo.math.distance.JensenShannonDistance;
import org.meteoinfo.math.distance.ManhattanDistance;
import org.meteoinfo.math.distance.MinkowskiDistance;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;

public class DistanceUtil {
    public static Distance getDistanceFunc(String metric) {
        switch (metric.toLowerCase()) {
            case "chebyshev": {
                return new ChebyshevDistance();
            }
            case "cityblock": {
                return new ManhattanDistance();
            }
            case "correlation": {
                return new CorrelationDistance();
            }
            case "euclidean": {
                return new EuclideanDistance();
            }
            case "hamming": {
                return new HammingDistance();
            }
            case "jaccard": {
                return new JaccardDistance();
            }
            case "jensenshannon": {
                return new JensenShannonDistance();
            }
        }
        return null;
    }

    public static Distance getDistanceFunc(String metric, int p) {
        switch (metric.toLowerCase()) {
            case "minkowski": {
                return new MinkowskiDistance(p);
            }
        }
        return null;
    }

    public static Array calculateDistance(Distance distance, Array data) throws InvalidRangeException {
        int[] shape = data.getShape();
        int m = shape[0];
        int n = shape[1];
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m * (m - 1) / 2});
        int idx = 0;
        for (int i = 0; i < m - 1; ++i) {
            Array xa = data.section(new int[]{i, 0}, new int[]{1, n});
            double[] x = (double[])xa.get1DJavaArray(Double.TYPE);
            int j = i + 1;
            while (j < m) {
                Array ya = data.section(new int[]{j++, 0}, new int[]{1, n});
                double[] y = (double[])ya.get1DJavaArray(Double.TYPE);
                double dist = distance.apply(x, y);
                r.setDouble(idx, dist);
                ++idx;
            }
        }
        return r;
    }
}

