/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.random;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.core.jdkmath.AccurateMath;
import org.apache.commons.rng.core.source32.MersenneTwister;
import org.apache.commons.rng.simple.RandomSource;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class MTRandom
extends MersenneTwister {
    private double nextGaussian = Double.NaN;

    public MTRandom() {
        super(RandomSource.createIntArray((int)624));
    }

    public MTRandom(int seed) {
        super(RandomSource.createIntArray((int)seed));
    }

    public Array rand(int n) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, this.nextDouble());
            ++i;
        }
        return r;
    }

    public Array rand(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, this.nextDouble());
            ++i;
        }
        return a;
    }

    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = Math.sqrt(-2.0 * AccurateMath.log((double)y));
            random = r * AccurateMath.cos((double)alpha);
            this.nextGaussian = r * AccurateMath.sin((double)alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    public double randn() {
        return this.nextGaussian();
    }

    public Array randn(int n) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, this.nextGaussian());
            ++i;
        }
        return r;
    }

    public Array randn(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, this.nextGaussian());
            ++i;
        }
        return a;
    }

    public int randint(int bound) {
        return this.nextInt(bound);
    }

    public Array randint(int bound, int n) {
        Array a = Array.factory((DataType)DataType.INT, (int[])new int[]{n});
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)this.nextInt(bound));
            ++i;
        }
        return a;
    }

    public Array randint(int bound, List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.INT, (int[])ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)this.nextInt(bound));
            ++i;
        }
        return a;
    }

    public void shuffle(Array x, int axis) throws InvalidRangeException {
        int nDim = (x = x.copyIfView()).getRank();
        if (nDim == 1) {
            for (int i = (int)x.getSize() - 1; i > 0; --i) {
                int ii = this.nextInt(i);
                if (ii == i) continue;
                Object tmp = x.getObject(ii);
                x.setObject(ii, x.getObject(i));
                x.setObject(i, tmp);
            }
        } else {
            int n = x.getShape()[axis];
            int[] shape = x.getShape();
            shape[axis] = 1;
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < nDim; ++i) {
                ranges.add(new Range(0, shape[i] - 1, 1));
            }
            Index index = x.getIndex();
            for (int i = n - 1; i > 0; --i) {
                int ii = this.nextInt(i);
                if (ii == i) continue;
                ranges.set(axis, new Range(ii, ii, 1));
                Array tmp1 = x.section(ranges).copy();
                Index iIndex1 = index.section(ranges);
                ranges.set(axis, new Range(i, i, 1));
                Array tmp2 = x.section(ranges);
                Index iIndex2 = index.section(ranges);
                IndexIterator iter1 = tmp1.getIndexIterator();
                IndexIterator iter2 = tmp2.getIndexIterator();
                while (iter2.hasNext()) {
                    x.setObject(iIndex1, iter2.getObjectNext());
                    iIndex1.incr();
                }
                while (iter1.hasNext()) {
                    x.setObject(iIndex2, iter1.getObjectNext());
                    iIndex2.incr();
                }
            }
        }
    }
}

